/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.index.graphql.query.GraphQLQueryParser;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.index.query.AttributeFilter;
import org.kie.kogito.index.query.FilterCondition;
import org.kie.kogito.index.query.QueryFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLQueryMapper
implements Function<GraphQLInputObjectType, GraphQLQueryParser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLQueryMapper.class);

    @Override
    public GraphQLQueryParser apply(GraphQLInputObjectType type) {
        GraphQLQueryParser parser = new GraphQLQueryParser();
        type.getFields().forEach(field -> {
            LOGGER.debug("Parser type: {}, field = {}:{}", new Object[]{type.getName(), field.getName(), field.getType().getName()});
            if (this.isEnumFilterType(field.getType())) {
                parser.mapAttribute(field.getName(), this.mapEnumArgument(field.getName()));
            } else if (field.getType() instanceof GraphQLList || field.getType().getName().equals(type.getName())) {
                parser.mapAttribute(field.getName(), this.mapRecursiveArgument(field.getName(), parser));
            } else {
                switch (field.getType().getName()) {
                    case "IdArgument": {
                        parser.mapAttribute(field.getName(), this.mapIdArgument(field.getName()));
                        break;
                    }
                    case "StringArgument": {
                        parser.mapAttribute(field.getName(), this.mapStringArgument(field.getName()));
                        break;
                    }
                    case "StringArrayArgument": {
                        parser.mapAttribute(field.getName(), this.mapStringArrayArgument(field.getName()));
                        break;
                    }
                    case "BooleanArgument": {
                        parser.mapAttribute(field.getName(), this.mapBooleanArgument(field.getName()));
                        break;
                    }
                    case "DateArgument": {
                        parser.mapAttribute(field.getName(), this.mapDateArgument(field.getName()));
                        break;
                    }
                    case "NumericArgument": {
                        parser.mapAttribute(field.getName(), this.mapNumericArgument(field.getName()));
                        break;
                    }
                    case "KogitoMetadataArgument": {
                        parser.mapAttribute(field.getName(), this.mapSubEntityArgument(field.getName(), GraphQLQueryParserRegistry.get().getParser("KogitoMetadataArgument")));
                        break;
                    }
                    default: {
                        parser.mapAttribute(field.getName(), this.mapSubEntityArgument(field.getName(), new GraphQLQueryMapper().apply((GraphQLInputObjectType)field.getType())));
                    }
                }
            }
        });
        return parser;
    }

    private boolean isEnumFilterType(GraphQLInputType inputType) {
        if (!(inputType instanceof GraphQLInputObjectType)) {
            return false;
        }
        GraphQLInputObjectType type = (GraphQLInputObjectType)inputType;
        if (type.getFields().isEmpty()) {
            return false;
        }
        return type.getFields().stream().filter(f -> {
            if (f.getType() instanceof GraphQLEnumType) {
                return true;
            }
            if (f.getType() instanceof GraphQLList) {
                return ((GraphQLList)f.getType()).getWrappedType() instanceof GraphQLEnumType;
            }
            return false;
        }).collect(Collectors.counting()) == (long)type.getFields().size();
    }

    private Function<Object, Stream<AttributeFilter>> mapRecursiveArgument(String joining, GraphQLQueryParser parser) {
        return argument -> {
            Stream stream = ((List)argument).stream().flatMap(args -> parser.apply(args).stream());
            List filters = stream.collect(Collectors.toList());
            FilterCondition condition = FilterCondition.fromLabel((String)joining);
            switch (condition) {
                case AND: {
                    return Stream.of(QueryFilterFactory.and(filters));
                }
                case OR: {
                    return Stream.of(QueryFilterFactory.or(filters));
                }
            }
            return null;
        };
    }

    private Function<Object, Stream<AttributeFilter>> mapSubEntityArgument(String joining, GraphQLQueryParser parser) {
        return argument -> parser.apply((Map)argument).stream().map(f -> {
            f.setAttribute(joining + "." + f.getAttribute());
            return f;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapIdArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IN: {
                    return QueryFilterFactory.in((String)attribute, (List)((List)entry.getValue()));
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, (Object)entry.getValue().toString());
                }
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapStringArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IN: {
                    return QueryFilterFactory.in((String)attribute, (List)((List)entry.getValue()));
                }
                case LIKE: {
                    return QueryFilterFactory.like((String)attribute, (String)entry.getValue().toString());
                }
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, (Object)entry.getValue().toString());
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapDateArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, (Object)entry.getValue().toString());
                }
                case GT: {
                    return QueryFilterFactory.greaterThan((String)attribute, (Object)entry.getValue().toString());
                }
                case GTE: {
                    return QueryFilterFactory.greaterThanEqual((String)attribute, (Object)entry.getValue().toString());
                }
                case LT: {
                    return QueryFilterFactory.lessThan((String)attribute, (Object)entry.getValue().toString());
                }
                case LTE: {
                    return QueryFilterFactory.lessThanEqual((String)attribute, (Object)entry.getValue().toString());
                }
                case BETWEEN: {
                    Map value = (Map)entry.getValue();
                    return QueryFilterFactory.between((String)attribute, (Object)value.get("from").toString(), (Object)value.get("to").toString());
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapStringArrayArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case CONTAINS: {
                    return QueryFilterFactory.contains((String)attribute, (String)entry.getValue().toString());
                }
                case CONTAINS_ALL: {
                    return QueryFilterFactory.containsAll((String)attribute, (List)((List)entry.getValue()));
                }
                case CONTAINS_ANY: {
                    return QueryFilterFactory.containsAny((String)attribute, (List)((List)entry.getValue()));
                }
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapBooleanArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, (Object)entry.getValue().toString());
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapNumericArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IN: {
                    return QueryFilterFactory.in((String)attribute, (List)((List)entry.getValue()));
                }
                case IS_NULL: {
                    return Boolean.TRUE.equals(entry.getValue()) ? QueryFilterFactory.isNull((String)attribute) : QueryFilterFactory.notNull((String)attribute);
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, entry.getValue());
                }
                case GT: {
                    return QueryFilterFactory.greaterThan((String)attribute, entry.getValue());
                }
                case GTE: {
                    return QueryFilterFactory.greaterThanEqual((String)attribute, entry.getValue());
                }
                case LT: {
                    return QueryFilterFactory.lessThan((String)attribute, entry.getValue());
                }
                case LTE: {
                    return QueryFilterFactory.lessThanEqual((String)attribute, entry.getValue());
                }
                case BETWEEN: {
                    Map value = (Map)entry.getValue();
                    return QueryFilterFactory.between((String)attribute, value.get("from"), value.get("to"));
                }
            }
            return null;
        });
    }

    private Function<Object, Stream<AttributeFilter>> mapEnumArgument(String attribute) {
        return argument -> ((Map)argument).entrySet().stream().map(entry -> {
            FilterCondition condition = FilterCondition.fromLabel((String)((String)entry.getKey()));
            switch (condition) {
                case IN: {
                    return QueryFilterFactory.in((String)attribute, (List)((List)entry.getValue()));
                }
                case EQUAL: {
                    return QueryFilterFactory.equalTo((String)attribute, (Object)entry.getValue().toString());
                }
            }
            return null;
        });
    }
}

