/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.cache;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.query.AttributeFilter;
import org.kie.kogito.index.query.QueryFilterFactory;

@QuarkusTest
public class QueryTest {
    @Inject
    CacheService cacheService;

    @BeforeEach
    public void setup() {
        this.cacheService.getProcessInstancesCache().clear();
    }

    @Test
    public void testProcessInstanceQueries() {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessId = processId + "_sub";
        String subProcessInstanceId = UUID.randomUUID().toString();
        ProcessInstance processInstance = TestUtils.getProcessInstance(processId, processInstanceId, ProcessInstanceState.ACTIVE.ordinal(), null, null);
        this.cacheService.getProcessInstancesCache().put((Object)processInstanceId, (Object)processInstance);
        this.cacheService.getProcessInstancesCache().put((Object)subProcessInstanceId, (Object)TestUtils.getProcessInstance(subProcessId, subProcessInstanceId, ProcessInstanceState.COMPLETED.ordinal(), processInstanceId, processId));
        this.queryAndAssert(QueryFilterFactory.in((String)"state", Arrays.asList(ProcessInstanceState.ACTIVE.ordinal(), ProcessInstanceState.COMPLETED.ordinal())), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.equalTo((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal()), processInstanceId);
        this.queryAndAssert(QueryFilterFactory.greaterThan((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal()), subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.greaterThanEqual((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal()), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.lessThan((String)"state", (Object)ProcessInstanceState.COMPLETED.ordinal()), processInstanceId);
        this.queryAndAssert(QueryFilterFactory.lessThanEqual((String)"state", (Object)ProcessInstanceState.COMPLETED.ordinal()), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.between((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal(), (Object)ProcessInstanceState.COMPLETED.ordinal()), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.isNull((String)"rootProcessInstanceId"), processInstanceId);
        this.queryAndAssert(QueryFilterFactory.notNull((String)"rootProcessInstanceId"), subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.in((String)"id", Arrays.asList(processInstanceId, subProcessInstanceId)), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.equalTo((String)"rootProcessInstanceId", (Object)processInstanceId), subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.in((String)"processId", Arrays.asList(processId, subProcessId)), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.equalTo((String)"processId", (Object)subProcessId), subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.contains((String)"roles", (String)"admin"), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.containsAny((String)"roles", Arrays.asList("admin", "kogito")), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.containsAll((String)"roles", Arrays.asList("admin", "kogito")), new String[0]);
        this.queryAndAssert(QueryFilterFactory.isNull((String)"roles"), new String[0]);
        this.queryAndAssert(QueryFilterFactory.isNull((String)"end"), processInstanceId);
        this.queryAndAssert(QueryFilterFactory.lessThan((String)"start", (Object)new Date().getTime()), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.lessThanEqual((String)"start", (Object)new Date().getTime()), processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryFilterFactory.greaterThan((String)"start", (Object)new Date().getTime()), new String[0]);
        this.queryAndAssert(QueryFilterFactory.greaterThanEqual((String)"start", (Object)new Date().getTime()), new String[0]);
        this.queryAndAssert(QueryFilterFactory.equalTo((String)"start", (Object)processInstance.getStart().toInstant().toEpochMilli()), processInstanceId);
    }

    private void queryAndAssert(AttributeFilter filter, String ... ids) {
        List instances = this.cacheService.getProcessInstancesCache().query().filter(Collections.singletonList(filter)).execute();
        ((ListAssert)Assertions.assertThat((List)instances).hasSize(ids == null ? 0 : ids.length)).extracting("id").containsExactlyInAnyOrder((Object[])ids);
    }
}

