/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.IndexingService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ReactiveMessagingEventConsumerTest {
    @Mock
    IndexingService service;
    @Mock
    EventBus eventBus;
    @InjectMocks
    ReactiveMessagingEventConsumer consumer;

    @Test
    public void testOnProcessInstanceDomainEvent() throws Exception {
        Mockito.when((Object)this.eventBus.request((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Handler)ArgumentMatchers.any(Handler.class))).thenAnswer(invocation -> {
            ((Handler)invocation.getArgument(2)).handle(null);
            return null;
        });
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        KogitoProcessCloudEvent event = TestUtils.getProcessCloudEvent(processId, processInstanceId, ProcessInstanceState.ACTIVE, null, null, null);
        this.consumer.onProcessInstanceDomainEvent(event).toCompletableFuture().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ObjectNode.class);
        ((EventBus)Mockito.verify((Object)this.eventBus)).request((String)ArgumentMatchers.eq((Object)String.format("kogito-domain-events-%s", processId)), captor.capture(), (Handler)ArgumentMatchers.any(Handler.class));
        ((MapAssert)JsonAssertions.assertThatJson((Object)((ObjectNode)captor.getValue()).toString()).isObject().containsEntry((Object)"id", (Object)processInstanceId)).containsEntry((Object)"processId", (Object)processId);
    }

    @Test
    public void testOnUserTaskInstanceDomainEvent() throws Exception {
        Mockito.when((Object)this.eventBus.request((String)ArgumentMatchers.any(), ArgumentMatchers.any(), (Handler)ArgumentMatchers.any(Handler.class))).thenAnswer(invocation -> {
            ((Handler)invocation.getArgument(2)).handle(null);
            return null;
        });
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        KogitoUserTaskCloudEvent event = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, null, null, "InProgress");
        this.consumer.onUserTaskInstanceDomainEvent(event).toCompletableFuture().get();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ObjectNode.class);
        ((EventBus)Mockito.verify((Object)this.eventBus)).request((String)ArgumentMatchers.eq((Object)String.format("kogito-domain-events-%s", processId)), captor.capture(), (Handler)ArgumentMatchers.any(Handler.class));
        ((MapAssert)JsonAssertions.assertThatJson((Object)((ObjectNode)captor.getValue()).toString()).isObject().containsEntry((Object)"id", (Object)processInstanceId)).containsEntry((Object)"processId", (Object)processId);
    }

    @Test
    public void testOnProcessInstanceEvent() throws Exception {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)Mockito.mock(KogitoProcessCloudEvent.class);
        this.consumer.onProcessInstanceEvent(event).toCompletableFuture().get();
        ((IndexingService)Mockito.verify((Object)this.service)).indexProcessInstance((ProcessInstance)event.getData());
    }

    @Test
    public void testOnUserTaskInstanceEvent() throws Exception {
        KogitoUserTaskCloudEvent event = (KogitoUserTaskCloudEvent)Mockito.mock(KogitoUserTaskCloudEvent.class);
        this.consumer.onUserTaskInstanceEvent(event).toCompletableFuture().get();
        ((IndexingService)Mockito.verify((Object)this.service)).indexUserTaskInstance((UserTaskInstance)event.getData());
    }
}

