/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.messaging.KogitoJobCloudEventDeserializer;
import org.kie.kogito.index.messaging.KogitoProcessCloudEventDeserializer;
import org.kie.kogito.index.messaging.KogitoUserTaskCloudEventDeserializer;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;

public class KogitoCloudEventDeserializerTest {
    @Test
    public void testProcessDeserializer() throws Exception {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)new KogitoProcessCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("process_instance_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"b50a3dd4-a955-49c4-a055-f30a4d768f87")).hasFieldOrPropertyWithValue("parentProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("processInstanceId", (Object)"c2fa5c5e-3002-44c7-aef7-bce82297e3fe")).hasFieldOrPropertyWithValue("state", (Object)2)).hasFieldOrPropertyWithValue("rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("rootProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("kogitoAddons", (Object)"jobs-management,prometheus-monitoring,process-management")).hasFieldOrPropertyWithValue("time", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.110668Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("type", (Object)"ProcessInstanceEvent")).hasFieldOrPropertyWithValue("data.id", (Object)"c2fa5c5e-3002-44c7-aef7-bce82297e3fe")).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.end", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.parentProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", (Object)"f8868a2e-1bbb-47eb-93cf-fa46ff9dbfee")).hasFieldOrPropertyWithValue("data.rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("data.start", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.091Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.state", (Object)2)).hasFieldOrPropertyWithValue("specVersion", (Object)"0.3")).hasFieldOrPropertyWithValue("contentType", null)).hasFieldOrPropertyWithValue("schemaURL", null)).hasFieldOrPropertyWithValue("kogitoReferenceId", null);
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)((NodeInstance)((ProcessInstance)event.getData()).getNodes().get(0))).hasFieldOrPropertyWithValue("id", (Object)"54e66e2f-2acd-4d47-b8e6-991cb6372ad8")).hasFieldOrPropertyWithValue("exit", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("definitionId", (Object)"EndEvent_1")).hasFieldOrPropertyWithValue("nodeId", (Object)"3")).hasFieldOrPropertyWithValue("name", (Object)"End Event 1")).hasFieldOrPropertyWithValue("type", (Object)"EndNode")).hasFieldOrPropertyWithValue("enter", (Object)ZonedDateTime.parse("2019-08-20T19:26:02.092Z[UTC]", DateTimeFormatter.ISO_DATE_TIME));
        softly.assertAll();
    }

    @Test
    public void testProcessEmptyIdsDeserializer() throws Exception {
        KogitoProcessCloudEvent event = (KogitoProcessCloudEvent)new KogitoProcessCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("process_instance_empty_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"b50a3dd4-a955-49c4-a055-f30a4d768f87")).hasFieldOrPropertyWithValue("parentProcessInstanceId", null)).hasFieldOrPropertyWithValue("processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("processInstanceId", null)).hasFieldOrPropertyWithValue("rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("kogitoAddons", null)).hasFieldOrPropertyWithValue("type", (Object)"ProcessInstanceEvent")).hasFieldOrPropertyWithValue("data.id", null)).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.parentProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.processId", (Object)"hotelBooking")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.rootProcessId", (Object)"travels")).hasFieldOrPropertyWithValue("specVersion", (Object)"0.3")).hasFieldOrPropertyWithValue("contentType", null)).hasFieldOrPropertyWithValue("schemaURL", null)).hasFieldOrPropertyWithValue("kogitoReferenceId", null);
        softly.assertAll();
    }

    @Test
    public void testUserTaskDeserializer() throws IOException {
        KogitoUserTaskCloudEvent event = (KogitoUserTaskCloudEvent)new KogitoUserTaskCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("user_task_instance_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"ef315bd2-93a9-456f-b539-d73c0c83c1df")).hasFieldOrPropertyWithValue("userTaskInstanceId", (Object)"228d5922-5e88-4bfa-8329-7116a5cbe58b")).hasFieldOrPropertyWithValue("state", (Object)"Completed")).hasFieldOrPropertyWithValue("processId", (Object)"travels")).hasFieldOrPropertyWithValue("processInstanceId", (Object)"f78fb147-ec22-4478-a592-3063add9f956")).hasFieldOrPropertyWithValue("rootProcessId", null)).hasFieldOrPropertyWithValue("rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("kogitoAddons", (Object)"jobs-management,prometheus-monitoring,process-management")).hasFieldOrPropertyWithValue("time", (Object)ZonedDateTime.parse("2019-08-30T11:48:37.857915Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("type", (Object)"UserTaskInstanceEvent")).hasFieldOrPropertyWithValue("specVersion", (Object)"0.3")).hasFieldOrPropertyWithValue("schemaURL", null)).hasFieldOrPropertyWithValue("contentType", null)).hasFieldOrPropertyWithValue("kogitoReferenceId", null)).hasFieldOrPropertyWithValue("data.id", (Object)"228d5922-5e88-4bfa-8329-7116a5cbe58b")).hasFieldOrPropertyWithValue("data.processId", (Object)"travels")).hasFieldOrPropertyWithValue("data.processInstanceId", (Object)"f78fb147-ec22-4478-a592-3063add9f956")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.rootProcessId", null)).hasFieldOrPropertyWithValue("data.state", (Object)"Completed")).hasFieldOrPropertyWithValue("data.description", (Object)"")).hasFieldOrPropertyWithValue("data.name", (Object)"Apply for visa")).hasFieldOrPropertyWithValue("data.referenceName", (Object)"http://localhost:8080/travels/{uuid}/ConfirmTravel/{task-uuid}")).hasFieldOrPropertyWithValue("data.priority", (Object)"1")).hasFieldOrPropertyWithValue("data.potentialGroups", Collections.emptySet())).hasFieldOrPropertyWithValue("data.potentialUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.actualOwner", null)).hasFieldOrPropertyWithValue("data.adminGroups", Collections.emptySet())).hasFieldOrPropertyWithValue("data.adminUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.excludedUsers", Collections.emptySet())).hasFieldOrPropertyWithValue("data.completed", (Object)ZonedDateTime.parse("2019-08-30T11:48:37.828Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("data.started", (Object)ZonedDateTime.parse("2019-08-30T11:47:42.886Z[UTC]", DateTimeFormatter.ISO_DATE_TIME));
        softly.assertAll();
    }

    @Test
    public void testJobDeserializer() throws IOException {
        KogitoJobCloudEvent event = (KogitoJobCloudEvent)new KogitoJobCloudEventDeserializer().deserialize(null, this.getJsonEventBytes("job_event.json"));
        SoftAssertions softly = new SoftAssertions();
        ((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)((ProxyableObjectAssert)softly.assertThat((Object)event).isNotNull()).hasFieldOrPropertyWithValue("id", (Object)"2fea1981-321d-40e7-aa82-3730504c1672")).hasFieldOrPropertyWithValue("source", (Object)URI.create("http://localhost:8080/jobs"))).hasFieldOrPropertyWithValue("time", (Object)ZonedDateTime.parse("2020-01-16T20:40:58.227215Z[UTC]", DateTimeFormatter.ISO_DATE_TIME))).hasFieldOrPropertyWithValue("type", (Object)"JobEvent")).hasFieldOrPropertyWithValue("specVersion", (Object)"0.3")).hasFieldOrPropertyWithValue("schemaURL", null)).hasFieldOrPropertyWithValue("contentType", null)).hasFieldOrPropertyWithValue("processId", (Object)"timerscycle")).hasFieldOrPropertyWithValue("processInstanceId", (Object)"7c1d9b38-b462-47c5-8bf2-d9154f54957b")).hasFieldOrPropertyWithValue("rootProcessId", null)).hasFieldOrPropertyWithValue("rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.id", (Object)"8350b8b6-c5d9-432d-a339-a9fc85f642d4_0")).hasFieldOrPropertyWithValue("data.processId", (Object)"timerscycle")).hasFieldOrPropertyWithValue("data.processInstanceId", (Object)"7c1d9b38-b462-47c5-8bf2-d9154f54957b")).hasFieldOrPropertyWithValue("data.rootProcessInstanceId", null)).hasFieldOrPropertyWithValue("data.rootProcessId", null)).hasFieldOrPropertyWithValue("data.repeatInterval", (Object)1000L)).hasFieldOrPropertyWithValue("data.repeatLimit", (Object)Integer.MAX_VALUE)).hasFieldOrPropertyWithValue("data.scheduledId", (Object)"0")).hasFieldOrPropertyWithValue("data.retries", (Object)0)).hasFieldOrPropertyWithValue("data.status", (Object)"SCHEDULED")).hasFieldOrPropertyWithValue("data.executionCounter", (Object)0)).hasFieldOrPropertyWithValue("data.priority", (Object)0)).hasFieldOrPropertyWithValue("data.expirationTime", (Object)ZonedDateTime.parse("2020-01-16T20:40:58.918Z[UTC]", DateTimeFormatter.ISO_DATE_TIME));
        softly.assertAll();
    }

    private byte[] getJsonEventBytes(String file) throws IOException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);){
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

