/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mutations;

import com.fasterxml.jackson.databind.JsonNode;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.kie.kogito.index.CommonUtils;
import org.kie.kogito.index.api.ExecuteArgs;
import org.kie.kogito.index.graphql.AbstractGraphQLSchemaManager;
import org.kie.kogito.index.graphql.GraphQLMutationsProvider;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.DataIndexStorageService;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.MergeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputGraphQLMutationProvider
implements GraphQLMutationsProvider {
    private static Logger logger = LoggerFactory.getLogger(OutputGraphQLMutationProvider.class);
    private static final String COMPLETED_INSTANCE_ID = "completedInstanceId";

    public Map<String, DataFetcher<CompletableFuture<?>>> mutations(AbstractGraphQLSchemaManager schemaManager) {
        return Map.of("ExecuteAfter", env -> this.sharedOutput(schemaManager, env));
    }

    private CompletableFuture<JsonNode> sharedOutput(AbstractGraphQLSchemaManager schemaManager, DataFetchingEnvironment env) {
        DataIndexStorageService cacheService = schemaManager.getCacheService();
        ProcessDefinitionKey key = new ProcessDefinitionKey((String)OutputGraphQLMutationProvider.mandatoryArgument(env, "processId"), (String)OutputGraphQLMutationProvider.mandatoryArgument(env, "processVersion"));
        ProcessDefinition processDefinition = (ProcessDefinition)cacheService.getProcessDefinitionStorage().get((Object)key);
        if (processDefinition == null) {
            throw new IllegalArgumentException(key + "does not correspond to any existing process definition");
        }
        JsonNode input = JsonObjectUtils.fromValue((Object)env.getArgument("input"));
        String completedInstanceId = (String)env.getArgument(COMPLETED_INSTANCE_ID);
        if (completedInstanceId != null) {
            ProcessInstance processInstance = (ProcessInstance)cacheService.getProcessInstanceStorage().get((Object)completedInstanceId);
            if (processInstance != null) {
                input = MergeUtils.merge((JsonNode)input, (JsonNode)processInstance.getVariables().remove((Collection)env.getArgumentOrDefault("excludeProperties", Set.of("workflowdatainput"))));
            } else {
                logger.warn("Completed Instance Id {} cannot be found, using user input as it is", (Object)completedInstanceId);
            }
        } else {
            logger.warn("Missing completedInstanceId parameter, using user input as it is");
        }
        return schemaManager.getDataIndexApiExecutor().executeProcessInstance(processDefinition, ExecuteArgs.of((JsonNode)input));
    }

    private static <T> T mandatoryArgument(DataFetchingEnvironment env, String name) {
        Object result = env.getArgument(name);
        if (result == null) {
            throw new IllegalArgumentException("Missing " + name + " mandatory parameter");
        }
        return (T)result;
    }

    public TypeDefinitionRegistry registry() {
        return CommonUtils.loadSchemaDefinitionFile((String)"mutation.schema.graphqls");
    }
}

