/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.index.storage.ModelProcessDefinitionStorage;

public class ModelDataIndexStorageServiceTest {
    @Test
    void testIdAndVersion() {
        this.assertKeyConversion(new ProcessDefinitionKey("Javierito", "1_0"));
    }

    @Test
    void testIdEmptyVersion() {
        this.assertKeyConversion(new ProcessDefinitionKey("Javierito", ""));
    }

    @Test
    void testIdNullVersion() {
        this.assertKeyConversion(new ProcessDefinitionKey("Javierito", null));
    }

    private void assertKeyConversion(ProcessDefinitionKey key) {
        HashSet<ProcessDefinitionKey> set = new HashSet<ProcessDefinitionKey>();
        set.add(key);
        ProcessDefinitionKey deserializedKey = ModelProcessDefinitionStorage.fromString((String)ModelProcessDefinitionStorage.toString((ProcessDefinitionKey)key));
        set.add(deserializedKey);
        Assertions.assertThat((Object)deserializedKey).isEqualTo((Object)key);
        Assertions.assertThat(set).hasSize(1);
    }
}

