/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.index.storage.ModelStorageFetcher;
import org.kie.kogito.persistence.api.Storage;

public class ModelProcessDefinitionStorage
extends ModelStorageFetcher<ProcessDefinitionKey, ProcessDefinition>
implements Storage<ProcessDefinitionKey, ProcessDefinition> {
    private static final String VERSION_SEPARATOR = "$v:";

    static ProcessDefinitionKey fromString(String key) {
        int indexOf = key.indexOf(VERSION_SEPARATOR);
        return indexOf == -1 ? new ProcessDefinitionKey(key, null) : new ProcessDefinitionKey(key.substring(0, indexOf), key.substring(indexOf + VERSION_SEPARATOR.length()));
    }

    static String toString(ProcessDefinitionKey key) {
        String id = key.getId();
        String version = key.getVersion();
        return version == null ? id : id + VERSION_SEPARATOR + version;
    }

    public ModelProcessDefinitionStorage(Storage<String, ProcessDefinition> storage) {
        super(storage, ModelProcessDefinitionStorage::toString, ModelProcessDefinitionStorage::fromString);
    }

    public ProcessDefinition put(ProcessDefinitionKey key, ProcessDefinition value) {
        return (ProcessDefinition)this.storage.put((Object)ModelProcessDefinitionStorage.toString(key), (Object)value);
    }

    public ProcessDefinition remove(ProcessDefinitionKey key) {
        return (ProcessDefinition)this.storage.remove((Object)ModelProcessDefinitionStorage.toString(key));
    }

    public boolean containsKey(ProcessDefinitionKey key) {
        return this.storage.containsKey((Object)ModelProcessDefinitionStorage.toString(key));
    }

    public Map<ProcessDefinitionKey, ProcessDefinition> entries() {
        return this.storage.entries().entrySet().stream().collect(Collectors.toMap(e -> ModelProcessDefinitionStorage.fromString((String)e.getKey()), Map.Entry::getValue));
    }

    public String getRootType() {
        return ProcessDefinition.class.getName();
    }
}

