/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashSet;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;

@ApplicationScoped
public class UserTaskInstanceAssignmentDataEventMerger
implements UserTaskInstanceEventMerger {
    @Override
    public UserTaskInstance merge(UserTaskInstance userTaskInstance, UserTaskInstanceDataEvent<?> data) {
        UserTaskInstanceAssignmentDataEvent event = (UserTaskInstanceAssignmentDataEvent)data;
        UserTaskInstanceAssignmentEventBody body = (UserTaskInstanceAssignmentEventBody)event.getData();
        switch (body.getAssignmentType()) {
            case "USER_OWNERS": {
                userTaskInstance.setPotentialUsers(new HashSet(body.getUsers()));
                break;
            }
            case "USER_GROUPS": {
                userTaskInstance.setPotentialGroups(new HashSet(body.getUsers()));
                break;
            }
            case "USERS_EXCLUDED": {
                userTaskInstance.setExcludedUsers(new HashSet(body.getUsers()));
                break;
            }
            case "ADMIN_GROUPS": {
                userTaskInstance.setAdminGroups(new HashSet(body.getUsers()));
                break;
            }
            case "ADMIN_USERS": {
                userTaskInstance.setAdminUsers(new HashSet(body.getUsers()));
            }
        }
        return userTaskInstance;
    }
}

