/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;

@ApplicationScoped
public class UserTaskInstanceAttachmentDataEventMerger
implements UserTaskInstanceEventMerger {
    @Override
    public UserTaskInstance merge(UserTaskInstance userTaskInstance, UserTaskInstanceDataEvent<?> data) {
        UserTaskInstanceAttachmentDataEvent event = (UserTaskInstanceAttachmentDataEvent)data;
        UserTaskInstanceAttachmentEventBody body = (UserTaskInstanceAttachmentEventBody)event.getData();
        ArrayList<Attachment> attachments = userTaskInstance.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            userTaskInstance.setAttachments(attachments);
        }
        switch (body.getEventType()) {
            case 1: 
            case 2: {
                Attachment attachment;
                Optional<Attachment> found = attachments.stream().filter(e -> e.getId().equals(body.getAttachmentId())).findAny();
                if (found.isEmpty()) {
                    attachment = new Attachment();
                    attachments.add(attachment);
                } else {
                    attachment = found.get();
                }
                attachment.setId(body.getAttachmentId());
                attachment.setName(body.getAttachmentName());
                attachment.setContent(body.getAttachmentURI().toString());
                attachment.setUpdatedBy(body.getEventUser() != null ? body.getEventUser() : "unknown");
                attachment.setUpdatedAt(DateTimeUtils.toZonedDateTime((Date)body.getEventDate()));
                break;
            }
            case 3: {
                attachments.removeIf(e -> e.getId().equals(body.getAttachmentId()));
            }
        }
        return userTaskInstance;
    }
}

