/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableEventBody;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UserTaskInstanceVariableDataEventMerger
implements UserTaskInstanceEventMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskInstanceVariableDataEventMerger.class);

    @Override
    public UserTaskInstance merge(UserTaskInstance userTaskInstance, UserTaskInstanceDataEvent<?> data) {
        UserTaskInstanceVariableDataEvent event = (UserTaskInstanceVariableDataEvent)data;
        try {
            UserTaskInstanceVariableEventBody body = (UserTaskInstanceVariableEventBody)event.getData();
            ObjectMapper mapper = JsonUtils.getObjectMapper();
            switch (body.getVariableType()) {
                case "INPUT": {
                    Map<String, Object> inVars = this.toMap(mapper, userTaskInstance.getInputs());
                    inVars.put(body.getVariableName(), body.getVariableValue());
                    userTaskInstance.setInputs((ObjectNode)mapper.valueToTree(inVars));
                    break;
                }
                case "OUTPUT": {
                    Map<String, Object> outVars = this.toMap(mapper, userTaskInstance.getOutputs());
                    outVars.put(body.getVariableName(), body.getVariableValue());
                    userTaskInstance.setOutputs((ObjectNode)mapper.valueToTree(outVars));
                }
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("error during unmarshalling variable instance", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("error during merging variable instance event", (Throwable)e);
        }
        return userTaskInstance;
    }

    private Map<String, Object> toMap(ObjectMapper mapper, ObjectNode node) throws JsonProcessingException, IllegalArgumentException {
        HashMap<String, Object> variables = null;
        variables = node == null ? new HashMap<String, Object>() : new HashMap((Map)mapper.treeToValue((TreeNode)node, HashMap.class));
        return variables;
    }
}

