/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event.mapper;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.merger.ProcessInstanceNodeDataEventMerger;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ProcessInstanceNodeDataEventMergerTest {
    private static final String HIRING_PROCESS_ID = "hiring";
    private static final String PROCESS_INSTANCE_ID = "7b8ea46e-ffe7-4fdd-8cf5-72a3f0353947";
    private static final String START_NODE_INSTANCE_ID = "35d525eb-868a-4056-91cc-dbc3804d157c";
    private static final String START = "Start";
    private static final String START_NODE_DEFINITION_ID = "_1639F738-45F3-4CD6-A80E-CCEBAA605D56";
    private static final String START_NODE_TYPE = "StartNode";
    private static final String ACTION_NODE_INSTANCE_ID = "08ee9c9c-cf67-47e5-a7e6-901a6f556c0a";
    private static final String ACTION_NODE = "New Hiring";
    private static final String ACTION_NODE_DEFINITION_ID = "_5BDBE48C-CC83-46A9-9D56-F846F8FC1045";
    private static final String ACTION_NODE_TYPE = "ActionNode";
    private static final String BOUNDARY_EVENT_NODE_INSTANCE_ID = "f22510d2-e0e5-460a-901e-494cda3dea26";
    private static final String BOUNDARY_EVENT_NODE_NODE = "BoundaryEvent";
    private static final String BOUNDARY_EVENT_NODE_NODE_DEFINITION_ID = "_116F3C54-A10E-4952-9E08-1CACE74CED0B";
    private static final String BOUNDARY_EVENT_NODE_NODE_TYPE = "BoundaryEventNode";
    private ProcessInstanceNodeDataEventMerger merger;
    private ProcessInstance pi;

    @BeforeEach
    public void setup() {
        this.merger = new ProcessInstanceNodeDataEventMerger();
        this.pi = new ProcessInstance();
        this.pi.setProcessId(HIRING_PROCESS_ID);
        this.pi.setProcessName(HIRING_PROCESS_ID);
        this.pi.setId(PROCESS_INSTANCE_ID);
        this.pi.setVersion("1.0");
        this.pi.setStart(ZonedDateTime.now());
        this.pi.setState(Integer.valueOf(1));
    }

    @Test
    public void testMergeProcessInstanceNodeDataEvents() {
        ProcessInstanceNodeDataEvent startNodeEnter = this.buildNodeEvent(START_NODE_INSTANCE_ID, START, START_NODE_DEFINITION_ID, START_NODE_TYPE, 1);
        this.merger.merge(this.pi, (ProcessInstanceDataEvent)startNodeEnter);
        ProcessInstanceNodeDataEvent startNodeExit = this.buildNodeEvent(START_NODE_INSTANCE_ID, START, START_NODE_DEFINITION_ID, START_NODE_TYPE, 2);
        this.merger.merge(this.pi, (ProcessInstanceDataEvent)startNodeExit);
        ProcessInstanceNodeDataEvent actionNodeEnter = this.buildNodeEvent(ACTION_NODE_INSTANCE_ID, ACTION_NODE, ACTION_NODE_DEFINITION_ID, ACTION_NODE_TYPE, 1);
        this.merger.merge(this.pi, (ProcessInstanceDataEvent)actionNodeEnter);
        ProcessInstanceNodeDataEvent actionNodeExit = this.buildNodeEvent(ACTION_NODE_INSTANCE_ID, ACTION_NODE, ACTION_NODE_DEFINITION_ID, ACTION_NODE_TYPE, 2);
        this.merger.merge(this.pi, (ProcessInstanceDataEvent)actionNodeExit);
        Assertions.assertThat((List)this.pi.getNodes()).hasSize(2);
        this.verifyNode((NodeInstance)this.pi.getNodes().get(0), (ProcessInstanceNodeEventBody)startNodeEnter.getData(), ((ProcessInstanceNodeEventBody)startNodeEnter.getData()).getEventDate(), ((ProcessInstanceNodeEventBody)startNodeExit.getData()).getEventDate());
        this.verifyNode((NodeInstance)this.pi.getNodes().get(1), (ProcessInstanceNodeEventBody)actionNodeEnter.getData(), ((ProcessInstanceNodeEventBody)actionNodeEnter.getData()).getEventDate(), ((ProcessInstanceNodeEventBody)actionNodeExit.getData()).getEventDate());
    }

    @Test
    public void testMergeBoundaryNodeExitEvent() {
        ProcessInstanceNodeDataEvent boundaryEvent = this.buildNodeEvent(BOUNDARY_EVENT_NODE_INSTANCE_ID, BOUNDARY_EVENT_NODE_NODE, BOUNDARY_EVENT_NODE_NODE_DEFINITION_ID, BOUNDARY_EVENT_NODE_NODE_TYPE, 2);
        this.merger.merge(this.pi, (ProcessInstanceDataEvent)boundaryEvent);
        Assertions.assertThat((List)this.pi.getNodes()).hasSize(1);
        this.verifyNode((NodeInstance)this.pi.getNodes().get(0), (ProcessInstanceNodeEventBody)boundaryEvent.getData(), ((ProcessInstanceNodeEventBody)boundaryEvent.getData()).getEventDate(), ((ProcessInstanceNodeEventBody)boundaryEvent.getData()).getEventDate());
    }

    private void verifyNode(NodeInstance nodeInstance, ProcessInstanceNodeEventBody eventBody, Date enter, Date exit) {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)nodeInstance).hasFieldOrPropertyWithValue("id", (Object)eventBody.getNodeInstanceId())).hasFieldOrPropertyWithValue("nodeId", (Object)eventBody.getNodeDefinitionId())).hasFieldOrPropertyWithValue("definitionId", (Object)eventBody.getNodeDefinitionId())).hasFieldOrPropertyWithValue("name", (Object)eventBody.getNodeName())).hasFieldOrPropertyWithValue("type", (Object)eventBody.getNodeType())).hasFieldOrPropertyWithValue("enter", (Object)DateTimeUtils.toZonedDateTime((Date)enter))).hasFieldOrPropertyWithValue("exit", (Object)DateTimeUtils.toZonedDateTime((Date)exit));
    }

    private ProcessInstanceNodeDataEvent buildNodeEvent(String nodeInstanceId, String nodeName, String nodeDefinitionId, String nodeType, Integer eventType) {
        return new ProcessInstanceNodeDataEvent(HIRING_PROCESS_ID, "", "", new HashMap(), ProcessInstanceNodeEventBody.create().processId(HIRING_PROCESS_ID).processInstanceId(PROCESS_INSTANCE_ID).nodeInstanceId(nodeInstanceId).nodeName(nodeName).nodeDefinitionId(nodeDefinitionId).nodeType(nodeType).eventDate(new Date()).eventType(eventType).build());
    }
}

