/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event.mapper;

import java.net.URI;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.index.storage.merger.UserTaskInstanceStateEventMerger;

class UserTaskInstanceEventMapperTest {
    private UserTaskInstanceStateEventMerger mapper = new UserTaskInstanceStateEventMerger();

    UserTaskInstanceEventMapperTest() {
    }

    private static Stream<Arguments> provideEndpoint() {
        String pId = UUID.randomUUID().toString();
        String taskId = UUID.randomUUID().toString();
        return Stream.of(Arguments.of((Object[])new Object[]{URI.create("/travels"), pId, "task", taskId, String.format("/travels/%s/task/%s", pId, taskId)}), Arguments.of((Object[])new Object[]{URI.create("http://localhost:8080/travels"), pId, "task", taskId, String.format("http://localhost:8080/travels/%s/task/%s", pId, taskId)}), Arguments.of((Object[])new Object[]{URI.create("http://localhost:8080/orderItems"), pId, "Verify_order", taskId, String.format("http://localhost:8080/orderItems/%s/Verify_order/%s", pId, taskId)}), Arguments.of((Object[])new Object[]{URI.create("/travels"), pId, "Apply for visa", taskId, String.format("/travels/%s/%s/%s", pId, "Apply%20for%20visa", taskId)}));
    }

    @ParameterizedTest
    @MethodSource(value={"provideEndpoint"})
    void testUserTaskEndpoint(URI source, String pId, String taskName, String taskId, String expected) {
        Assertions.assertThat((String)this.mapper.getEndpoint(source, pId, taskName, taskId)).isEqualTo(expected);
    }
}

