/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.DataIndexStorageService;
import org.kie.kogito.index.storage.ModelProcessDefinitionStorage;
import org.kie.kogito.index.storage.ModelProcessInstanceStorage;
import org.kie.kogito.index.storage.ModelUserTaskInstanceStorage;
import org.kie.kogito.index.storage.ProcessInstanceStorage;
import org.kie.kogito.index.storage.UserTaskInstanceStorage;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

@ApplicationScoped
public class ModelDataIndexStorageService
implements DataIndexStorageService {
    @Inject
    StorageService storageService;

    public Storage<ProcessDefinitionKey, ProcessDefinition> getProcessDefinitionStorage() {
        return new ModelProcessDefinitionStorage((Storage<String, ProcessDefinition>)this.storageService.getCache("processdefinitions", ProcessDefinition.class));
    }

    public ProcessInstanceStorage getProcessInstanceStorage() {
        return new ModelProcessInstanceStorage((Storage<String, ProcessInstance>)this.storageService.getCache("processinstances", ProcessInstance.class));
    }

    public UserTaskInstanceStorage getUserTaskInstanceStorage() {
        return new ModelUserTaskInstanceStorage((Storage<String, UserTaskInstance>)this.storageService.getCache("usertaskinstances", UserTaskInstance.class));
    }

    public Storage<String, Job> getJobsStorage() {
        return this.storageService.getCache("jobs", Job.class);
    }

    public Storage<String, ObjectNode> getDomainModelCache(String processId) {
        String rootType = (String)this.getProcessIdModelCache().get((Object)processId);
        return rootType == null ? null : this.storageService.getCache(this.getDomainModelCacheName(processId), ObjectNode.class, rootType);
    }

    public String getDomainModelCacheName(String processId) {
        return processId + "_domain";
    }

    public Storage<String, String> getProcessIdModelCache() {
        return this.storageService.getCache("processidmodel");
    }
}

