/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import java.util.Collection;
import org.kie.kogito.event.process.MultipleProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceSLADataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.ModelStorageFetcher;
import org.kie.kogito.index.storage.ProcessInstanceStorage;
import org.kie.kogito.index.storage.merger.ProcessInstanceErrorDataEventMerger;
import org.kie.kogito.index.storage.merger.ProcessInstanceEventMerger;
import org.kie.kogito.index.storage.merger.ProcessInstanceNodeDataEventMerger;
import org.kie.kogito.index.storage.merger.ProcessInstanceSLADataEventMerger;
import org.kie.kogito.index.storage.merger.ProcessInstanceStateDataEventMerger;
import org.kie.kogito.index.storage.merger.ProcessInstanceVariableDataEventMerger;
import org.kie.kogito.persistence.api.Storage;

public class ModelProcessInstanceStorage
extends ModelStorageFetcher<String, ProcessInstance>
implements ProcessInstanceStorage {
    private final ProcessInstanceErrorDataEventMerger errorMerger = new ProcessInstanceErrorDataEventMerger();
    private final ProcessInstanceNodeDataEventMerger nodeMerger = new ProcessInstanceNodeDataEventMerger();
    private final ProcessInstanceSLADataEventMerger slaMerger = new ProcessInstanceSLADataEventMerger();
    private final ProcessInstanceStateDataEventMerger stateMerger = new ProcessInstanceStateDataEventMerger();
    private final ProcessInstanceVariableDataEventMerger variableMerger = new ProcessInstanceVariableDataEventMerger();

    public ModelProcessInstanceStorage(Storage<String, ProcessInstance> storage) {
        super(storage);
    }

    public void indexError(ProcessInstanceErrorDataEvent event) {
        this.index(event, this.errorMerger);
    }

    public void indexNode(ProcessInstanceNodeDataEvent event) {
        this.index(event, this.nodeMerger);
    }

    public void indexSLA(ProcessInstanceSLADataEvent event) {
        this.index(event, this.slaMerger);
    }

    public void indexState(ProcessInstanceStateDataEvent event) {
        this.index(event, this.stateMerger);
    }

    public void indexVariable(ProcessInstanceVariableDataEvent event) {
        this.index(event, this.variableMerger);
    }

    public void indexGroup(MultipleProcessInstanceDataEvent events) {
        for (ProcessInstanceDataEvent event : (Collection)events.getData()) {
            if (event instanceof ProcessInstanceErrorDataEvent) {
                this.index(event, this.errorMerger);
                continue;
            }
            if (event instanceof ProcessInstanceNodeDataEvent) {
                this.index(event, this.nodeMerger);
                continue;
            }
            if (event instanceof ProcessInstanceSLADataEvent) {
                this.index(event, this.slaMerger);
                continue;
            }
            if (event instanceof ProcessInstanceStateDataEvent) {
                this.index(event, this.stateMerger);
                continue;
            }
            if (!(event instanceof ProcessInstanceVariableDataEvent)) continue;
            this.index(event, this.variableMerger);
        }
    }

    private <T extends ProcessInstanceDataEvent<?>> void index(T event, ProcessInstanceEventMerger merger) {
        ProcessInstance processInstance = (ProcessInstance)this.storage.get((Object)event.getKogitoProcessInstanceId());
        if (processInstance == null) {
            processInstance = new ProcessInstance();
            processInstance.setId(event.getKogitoProcessInstanceId());
            processInstance.setProcessId(event.getKogitoProcessId());
        }
        this.storage.put((Object)event.getKogitoProcessInstanceId(), (Object)merger.merge(processInstance, event));
    }
}

