/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import io.smallrye.mutiny.Multi;
import java.util.function.Function;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageFetcher;
import org.kie.kogito.persistence.api.query.Query;

public abstract class ModelStorageFetcher<K, V>
implements StorageFetcher<K, V> {
    protected final Storage<String, V> storage;
    private final Function<K, String> toString;
    private final Function<String, K> fromString;

    public ModelStorageFetcher(Storage<String, V> storage) {
        this(storage, Object::toString, s -> s);
    }

    public ModelStorageFetcher(Storage<String, V> storage, Function<K, String> toString, Function<String, K> fromString) {
        this.storage = storage;
        this.toString = toString;
        this.fromString = fromString;
    }

    public Multi<V> objectCreatedListener() {
        return this.storage.objectCreatedListener();
    }

    public Multi<V> objectUpdatedListener() {
        return this.storage.objectUpdatedListener();
    }

    public Multi<K> objectRemovedListener() {
        return this.storage.objectRemovedListener().map(this.fromString);
    }

    public Query<V> query() {
        return this.storage.query();
    }

    public V get(K key) {
        return (V)this.storage.get((Object)this.toString.apply(key));
    }

    public void clear() {
        this.storage.clear();
    }
}

