/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage;

import java.util.ArrayList;
import java.util.Collection;
import org.kie.kogito.event.usertask.MultipleUserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.ModelStorageFetcher;
import org.kie.kogito.index.storage.UserTaskInstanceStorage;
import org.kie.kogito.index.storage.merger.UserTaskInstanceAssignmentDataEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceAttachmentDataEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceCommentDataEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceDeadlineDataEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceStateEventMerger;
import org.kie.kogito.index.storage.merger.UserTaskInstanceVariableDataEventMerger;
import org.kie.kogito.persistence.api.Storage;

public class ModelUserTaskInstanceStorage
extends ModelStorageFetcher<String, UserTaskInstance>
implements UserTaskInstanceStorage {
    private final UserTaskInstanceAssignmentDataEventMerger assignmentMerger = new UserTaskInstanceAssignmentDataEventMerger();
    private final UserTaskInstanceAttachmentDataEventMerger attachmentMerger = new UserTaskInstanceAttachmentDataEventMerger();
    private final UserTaskInstanceCommentDataEventMerger commentMerger = new UserTaskInstanceCommentDataEventMerger();
    private final UserTaskInstanceDeadlineDataEventMerger deadlineMerger = new UserTaskInstanceDeadlineDataEventMerger();
    private final UserTaskInstanceVariableDataEventMerger variableMerger = new UserTaskInstanceVariableDataEventMerger();
    private final UserTaskInstanceStateEventMerger stateMerger = new UserTaskInstanceStateEventMerger();

    public ModelUserTaskInstanceStorage(Storage<String, UserTaskInstance> storage) {
        super(storage);
    }

    public void indexAssignment(UserTaskInstanceAssignmentDataEvent event) {
        this.index(event, this.assignmentMerger);
    }

    public void indexAttachment(UserTaskInstanceAttachmentDataEvent event) {
        this.index(event, this.attachmentMerger);
    }

    public void indexDeadline(UserTaskInstanceDeadlineDataEvent event) {
        this.index(event, this.deadlineMerger);
    }

    public void indexState(UserTaskInstanceStateDataEvent event) {
        this.index(event, this.stateMerger);
    }

    public void indexVariable(UserTaskInstanceVariableDataEvent event) {
        this.index(event, this.variableMerger);
    }

    public void indexComment(UserTaskInstanceCommentDataEvent event) {
        this.index(event, this.commentMerger);
    }

    public void indexGroup(MultipleUserTaskInstanceDataEvent events) {
        for (UserTaskInstanceDataEvent event : (Collection)events.getData()) {
            if (event instanceof UserTaskInstanceAssignmentDataEvent) {
                this.index((UserTaskInstanceAssignmentDataEvent)event, this.assignmentMerger);
                continue;
            }
            if (event instanceof UserTaskInstanceAttachmentDataEvent) {
                this.index((UserTaskInstanceAttachmentDataEvent)event, this.attachmentMerger);
                continue;
            }
            if (event instanceof UserTaskInstanceDeadlineDataEvent) {
                this.index((UserTaskInstanceDeadlineDataEvent)event, this.deadlineMerger);
                continue;
            }
            if (event instanceof UserTaskInstanceStateDataEvent) {
                this.index((UserTaskInstanceStateDataEvent)event, this.stateMerger);
                continue;
            }
            if (event instanceof UserTaskInstanceCommentDataEvent) {
                this.index((UserTaskInstanceCommentDataEvent)event, this.commentMerger);
                continue;
            }
            if (!(event instanceof UserTaskInstanceVariableDataEvent)) continue;
            this.index((UserTaskInstanceVariableDataEvent)event, this.variableMerger);
        }
    }

    private <T extends UserTaskInstanceDataEvent<?>> void index(T event, UserTaskInstanceEventMerger merger) {
        UserTaskInstance taskInstance = (UserTaskInstance)this.storage.get((Object)event.getKogitoUserTaskInstanceId());
        if (taskInstance == null) {
            taskInstance = new UserTaskInstance();
            taskInstance.setId(event.getKogitoUserTaskInstanceId());
            taskInstance.setProcessInstanceId(event.getKogitoProcessInstanceId());
            taskInstance.setProcessId(event.getKogitoProcessId());
            taskInstance.setRootProcessId(event.getKogitoRootProcessId());
            taskInstance.setRootProcessInstanceId(event.getKogitoRootProcessInstanceId());
            taskInstance.setAttachments(new ArrayList());
            taskInstance.setComments(new ArrayList());
        }
        this.storage.put((Object)event.getKogitoUserTaskInstanceId(), (Object)merger.merge(taskInstance, event));
    }
}

