/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import jakarta.enterprise.context.ApplicationScoped;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.MilestoneStatus;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.merger.ProcessInstanceEventMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcessInstanceNodeDataEventMerger
extends ProcessInstanceEventMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceNodeDataEventMerger.class);

    @Override
    public ProcessInstance merge(ProcessInstance pi, ProcessInstanceDataEvent<?> data) {
        ProcessInstanceNodeDataEvent event = (ProcessInstanceNodeDataEvent)data;
        pi = this.getOrNew(pi, data, ((ProcessInstanceNodeEventBody)event.getData()).getEventDate());
        List nodeInstances = Optional.ofNullable(pi.getNodes()).orElse(new ArrayList());
        ProcessInstanceNodeEventBody body = (ProcessInstanceNodeEventBody)event.getData();
        NodeInstance nodeInstance = nodeInstances.stream().filter(e -> body.getNodeInstanceId().equals(e.getId())).findAny().orElse(new NodeInstance());
        nodeInstances.removeIf(e -> e.getId().equals(body.getNodeInstanceId()));
        LOGGER.debug("before merging: {}", (Object)nodeInstance);
        nodeInstance.setDefinitionId(body.getNodeDefinitionId());
        nodeInstance.setId(body.getNodeInstanceId());
        nodeInstance.setNodeId(body.getNodeDefinitionId());
        nodeInstance.setName(body.getNodeName());
        nodeInstance.setType(body.getNodeType());
        nodeInstance.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)body.getSlaDueDate()));
        if (body.isRetrigger() != null) {
            nodeInstance.setRetrigger(body.isRetrigger());
        }
        ZonedDateTime eventDate = DateTimeUtils.toZonedDateTime((Date)body.getEventDate());
        switch (body.getEventType()) {
            case 1: {
                nodeInstance.setEnter(eventDate);
                break;
            }
            case 2: {
                nodeInstance.setExit(eventDate);
            }
            default: {
                if (nodeInstance.getEnter() != null) break;
                nodeInstance.setEnter(eventDate);
            }
        }
        nodeInstances.add(nodeInstance);
        if ("MilestoneNode".equals(((ProcessInstanceNodeEventBody)event.getData()).getNodeType())) {
            List milestones = Optional.ofNullable(pi.getMilestones()).orElse(new ArrayList());
            Optional<Milestone> found = milestones.stream().filter(e -> body.getNodeInstanceId().equals(e.getId())).findAny();
            Milestone milestone = null;
            if (found.isEmpty()) {
                milestone = new Milestone();
                milestones.add(milestone);
            } else {
                milestone = found.get();
            }
            milestone.setId(nodeInstance.getId());
            milestone.setName(nodeInstance.getName());
            milestone.setStatus(nodeInstance.getExit() != null ? MilestoneStatus.COMPLETED.name() : MilestoneStatus.ACTIVE.name());
            milestones.add(milestone);
            pi.setMilestones(milestones);
        }
        if (pi.getDefinition() != null) {
            List nodes = Optional.ofNullable(pi.getDefinition().getNodes()).orElse(new ArrayList());
            nodes.removeIf(e -> e.getId().equals(body.getNodeDefinitionId()));
            Node node = new Node();
            node.setId(body.getNodeDefinitionId());
            node.setType(body.getNodeType());
            node.setUniqueId(body.getNodeDefinitionId());
            node.setMetadata(new HashMap());
            nodes.add(node);
            pi.getDefinition().setNodes(nodes);
        }
        LOGGER.debug("after merging: {}", (Object)nodeInstance);
        pi.setNodes(nodeInstances);
        return pi;
    }
}

