/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import com.google.common.base.Strings;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Set;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.merger.ProcessInstanceEventMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcessInstanceStateDataEventMerger
extends ProcessInstanceEventMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceStateDataEventMerger.class);

    @Override
    public ProcessInstance merge(ProcessInstance pi, ProcessInstanceDataEvent<?> data) {
        ProcessInstanceStateDataEvent event = (ProcessInstanceStateDataEvent)data;
        pi = this.getOrNew(pi, data, ((ProcessInstanceStateEventBody)event.getData()).getEventDate());
        LOGGER.debug("Value before merging: {}", (Object)pi);
        pi.setId(((ProcessInstanceStateEventBody)event.getData()).getProcessInstanceId());
        pi.setVersion(((ProcessInstanceStateEventBody)event.getData()).getProcessVersion());
        pi.setProcessId(((ProcessInstanceStateEventBody)event.getData()).getProcessId());
        pi.setProcessName(((ProcessInstanceStateEventBody)event.getData()).getProcessName());
        pi.setRootProcessInstanceId(((ProcessInstanceStateEventBody)event.getData()).getRootProcessInstanceId());
        pi.setRootProcessId(((ProcessInstanceStateEventBody)event.getData()).getRootProcessId());
        pi.setParentProcessInstanceId(((ProcessInstanceStateEventBody)event.getData()).getParentInstanceId());
        pi.setRoles(((ProcessInstanceStateEventBody)event.getData()).getRoles());
        pi.setState(((ProcessInstanceStateEventBody)event.getData()).getState());
        if (((ProcessInstanceStateEventBody)event.getData()).getEventType() == null || ((ProcessInstanceStateEventBody)event.getData()).getEventType() == 1) {
            pi.setStart(DateTimeUtils.toZonedDateTime((Date)((ProcessInstanceStateEventBody)event.getData()).getEventDate()));
            pi.setCreatedBy(((ProcessInstanceStateEventBody)event.getData()).getEventUser());
        } else if (((ProcessInstanceStateEventBody)event.getData()).getEventType() == 1) {
            pi.setEnd(DateTimeUtils.toZonedDateTime((Date)((ProcessInstanceStateEventBody)event.getData()).getEventDate()));
        } else if (((ProcessInstanceStateEventBody)event.getData()).getEventType() == 4) {
            pi.setError(null);
        }
        pi.setBusinessKey(((ProcessInstanceStateEventBody)event.getData()).getBusinessKey());
        pi.setAddons(Strings.isNullOrEmpty((String)event.getKogitoAddons()) ? null : Set.of(event.getKogitoAddons().split(",")));
        pi.setEndpoint(event.getSource() == null ? null : event.getSource().toString());
        pi.setLastUpdate(DateTimeUtils.toZonedDateTime((OffsetDateTime)event.getTime()));
        pi.setDefinition(this.definitions(event));
        pi.setUpdatedBy(((ProcessInstanceStateEventBody)event.getData()).getEventUser());
        pi.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)((ProcessInstanceStateEventBody)event.getData()).getSlaDueDate()));
        LOGGER.debug("Value after merging: {}", (Object)pi);
        return pi;
    }

    private ProcessDefinition definitions(ProcessInstanceStateDataEvent event) {
        LOGGER.debug("Value before merging: {}", (Object)event);
        ProcessDefinition pd = new ProcessDefinition();
        pd.setId(((ProcessInstanceStateEventBody)event.getData()).getProcessId());
        pd.setName(((ProcessInstanceStateEventBody)event.getData()).getProcessName());
        pd.setVersion(((ProcessInstanceStateEventBody)event.getData()).getProcessVersion());
        pd.setAddons(Strings.isNullOrEmpty((String)event.getKogitoAddons()) ? null : Set.of(event.getKogitoAddons().split(",")));
        pd.setRoles(((ProcessInstanceStateEventBody)event.getData()).getRoles());
        pd.setType(event.getKogitoProcessType());
        pd.setEndpoint(event.getSource() == null ? null : event.getSource().toString());
        LOGGER.debug("Value after merging: {}", (Object)pd);
        return pd;
    }
}

