/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;

@ApplicationScoped
public class UserTaskInstanceCommentDataEventMerger
implements UserTaskInstanceEventMerger {
    @Override
    public UserTaskInstance merge(UserTaskInstance userTaskInstance, UserTaskInstanceDataEvent<?> data) {
        UserTaskInstanceCommentDataEvent event = (UserTaskInstanceCommentDataEvent)data;
        UserTaskInstanceCommentEventBody body = (UserTaskInstanceCommentEventBody)event.getData();
        ArrayList<Comment> comments = userTaskInstance.getComments();
        if (comments == null) {
            comments = new ArrayList<Comment>();
            userTaskInstance.setComments(comments);
        }
        switch (body.getEventType()) {
            case 1: 
            case 2: {
                Comment comment;
                Optional<Comment> found = comments.stream().filter(e -> e.getId().equals(body.getCommentId())).findAny();
                if (found.isEmpty()) {
                    comment = new Comment();
                    comments.add(comment);
                } else {
                    comment = found.get();
                }
                comment.setId(body.getCommentId());
                comment.setContent(body.getCommentContent());
                comment.setUpdatedBy(body.getEventUser() != null ? body.getEventUser() : "unknown");
                comment.setUpdatedAt(DateTimeUtils.toZonedDateTime((Date)body.getEventDate()));
                break;
            }
            case 3: {
                comments.removeIf(e -> e.getId().equals(body.getCommentId()));
            }
        }
        return userTaskInstance;
    }
}

