/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.storage.merger;

import com.google.common.net.UrlEscapers;
import jakarta.enterprise.context.ApplicationScoped;
import java.net.URI;
import java.util.Date;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateEventBody;
import org.kie.kogito.index.CommonUtils;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.merger.UserTaskInstanceEventMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UserTaskInstanceStateEventMerger
implements UserTaskInstanceEventMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskInstanceStateEventMerger.class);

    @Override
    public UserTaskInstance merge(UserTaskInstance task, UserTaskInstanceDataEvent<?> data) {
        UserTaskInstanceStateDataEvent event = (UserTaskInstanceStateDataEvent)data;
        LOGGER.debug("value before merging: {}", (Object)task);
        task.setId(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskInstanceId());
        task.setProcessInstanceId(((UserTaskInstanceStateEventBody)event.getData()).getProcessInstanceId());
        task.setProcessId(event.getKogitoProcessId());
        task.setRootProcessId(event.getKogitoRootProcessId());
        task.setRootProcessInstanceId(event.getKogitoRootProcessInstanceId());
        task.setName(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskName());
        task.setDescription(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskDescription());
        task.setState(((UserTaskInstanceStateEventBody)event.getData()).getState());
        task.setPriority(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskPriority());
        if (task.getStarted() == null) {
            task.setStarted(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        } else if (CommonUtils.isTaskCompleted((String)((UserTaskInstanceStateEventBody)event.getData()).getEventType())) {
            task.setCompleted(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        }
        task.setActualOwner(((UserTaskInstanceStateEventBody)event.getData()).getActualOwner());
        task.setEndpoint(event.getSource() == null ? null : this.getEndpoint(event.getSource(), ((UserTaskInstanceStateEventBody)event.getData()).getProcessInstanceId(), ((UserTaskInstanceStateEventBody)event.getData()).getUserTaskName(), ((UserTaskInstanceStateEventBody)event.getData()).getExternalReferenceId()));
        task.setLastUpdate(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        task.setReferenceName(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskReferenceName());
        task.setExternalReferenceId(((UserTaskInstanceStateEventBody)event.getData()).getExternalReferenceId());
        task.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getSlaDueDate()));
        LOGGER.debug("value after merging: {}", (Object)task);
        return task;
    }

    public String getEndpoint(URI source, String pId, String taskName, String taskId) {
        String name = UrlEscapers.urlPathSegmentEscaper().escape(taskName);
        return source.toString() + String.format("/%s/%s/%s", pId, name, taskId);
    }
}

