/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.protostream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.index.infinispan.protostream.AbstractMarshaller;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;

public class ProcessInstanceMarshaller
extends AbstractMarshaller
implements MessageMarshaller<ProcessInstance> {
    public ProcessInstanceMarshaller(ObjectMapper mapper) {
        super(mapper);
    }

    public ProcessInstance readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ProcessInstance pi = new ProcessInstance();
        pi.setId(reader.readString("id"));
        pi.setProcessId(reader.readString("processId"));
        pi.setRoles((Set)reader.readCollection("roles", new HashSet(), String.class));
        pi.setVariables(this.jsonFromString(reader.readString("variables")));
        pi.setEndpoint(reader.readString("endpoint"));
        pi.setNodes((List)reader.readCollection("nodes", new ArrayList(), NodeInstance.class));
        pi.setState(reader.readInt("state"));
        pi.setStart(this.dateToZonedDateTime(reader.readDate("start")));
        pi.setEnd(this.dateToZonedDateTime(reader.readDate("end")));
        pi.setRootProcessInstanceId(reader.readString("rootProcessInstanceId"));
        pi.setRootProcessId(reader.readString("rootProcessId"));
        pi.setParentProcessInstanceId(reader.readString("parentProcessInstanceId"));
        pi.setProcessName(reader.readString("processName"));
        pi.setError((ProcessInstanceError)reader.readObject("error", ProcessInstanceError.class));
        pi.setAddons((Set)reader.readCollection("addons", new HashSet(), String.class));
        pi.setLastUpdate(this.dateToZonedDateTime(reader.readDate("lastUpdate")));
        pi.setBusinessKey(reader.readString("businessKey"));
        return pi;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ProcessInstance pi) throws IOException {
        writer.writeString("id", pi.getId());
        writer.writeString("processId", pi.getProcessId());
        writer.writeCollection("roles", (Collection)pi.getRoles(), String.class);
        writer.writeString("variables", pi.getVariables() == null ? null : pi.getVariables().toString());
        writer.writeString("endpoint", pi.getEndpoint());
        writer.writeCollection("nodes", (Collection)pi.getNodes(), NodeInstance.class);
        writer.writeInt("state", pi.getState());
        writer.writeDate("start", this.zonedDateTimeToDate(pi.getStart()));
        writer.writeDate("end", this.zonedDateTimeToDate(pi.getEnd()));
        writer.writeString("rootProcessInstanceId", pi.getRootProcessInstanceId());
        writer.writeString("rootProcessId", pi.getRootProcessId());
        writer.writeString("parentProcessInstanceId", pi.getParentProcessInstanceId());
        writer.writeString("processName", pi.getProcessName());
        writer.writeObject("error", (Object)pi.getError(), ProcessInstanceError.class);
        writer.writeCollection("addons", (Collection)pi.getAddons(), String.class);
        writer.writeDate("lastUpdate", this.zonedDateTimeToDate(pi.getLastUpdate()));
        writer.writeString("businessKey", pi.getBusinessKey());
    }

    public Class<? extends ProcessInstance> getJavaClass() {
        return ProcessInstance.class;
    }

    public String getTypeName() {
        return this.getJavaClass().getName();
    }
}

