/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonObject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.infinispan.cache.JsonDataFormatMarshaller;
import org.kie.kogito.index.infinispan.cache.KogitoCacheDefaultConfiguration;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InfinispanCacheManager
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheManager.class);
    private static final String PROCESS_INSTANCES_CACHE = "processinstances";
    private static final String USER_TASK_INSTANCES_CACHE = "usertaskinstances";
    private DataFormat jsonDataFormat = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JsonDataFormatMarshaller()).build();
    @Inject
    @ConfigProperty(name="kogito.cache.domain.template", defaultValue="kogito-template")
    String cacheTemplateName;
    @Inject
    RemoteCacheManager manager;

    @PostConstruct
    public void init() {
        this.manager.start();
    }

    @PreDestroy
    public void destroy() {
        this.manager.stop();
        try {
            this.manager.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Error trying to close Infinispan remote cache manager", (Throwable)ex);
        }
    }

    protected <K, V> RemoteCache<K, V> getOrCreateCache(String name, String template) {
        try {
            LOGGER.debug("Trying to get cache {} from the server", (Object)name);
            RemoteCache remoteCache = this.manager.getCache(name);
            if (remoteCache == null) {
                LOGGER.debug("Cache {} not found, trying to create a new one based on template {}", (Object)name, (Object)template);
                return this.manager.administration().createCache(name, template);
            }
            return remoteCache;
        }
        catch (HotRodClientException e) {
            if (e.isServerError()) {
                LOGGER.info("Creating a cache for '{}' based on the default configuration", (Object)name);
                RemoteCache cache = this.manager.administration().createCache(name, (BasicConfiguration)new KogitoCacheDefaultConfiguration(name));
                LOGGER.debug("Default cache created {}", (Object)cache.getName());
                return cache;
            }
            throw e;
        }
    }

    public Map<String, ProcessInstance> getProcessInstancesCache() {
        return this.getOrCreateCache(PROCESS_INSTANCES_CACHE, this.cacheTemplateName);
    }

    public Map<String, UserTaskInstance> getUserTaskInstancesCache() {
        return this.getOrCreateCache(USER_TASK_INSTANCES_CACHE, this.cacheTemplateName);
    }

    public Map<String, String> getProtobufCache() {
        return this.manager.getCache("___protobuf_metadata");
    }

    public Map<String, String> getProcessIdModelCache() {
        return this.manager.administration().getOrCreateCache("processidmodel", (String)null);
    }

    public Map<String, JsonObject> getDomainModelCache(String processId) {
        return this.getOrCreateCache(processId + "_domain", this.cacheTemplateName).withDataFormat(this.jsonDataFormat);
    }
}

