/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDataFormatMarshaller
extends AbstractMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDataFormatMarshaller.class);

    protected ByteBuffer objectToBuffer(Object object, int estimatedSize) throws IOException, InterruptedException {
        String json = object.toString();
        LOGGER.debug("Serializing JSON: \n{}", (Object)json);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        return new ByteBufferImpl(bytes, 0, bytes.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        try (JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(buf, offset, length));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public boolean isMarshallable(Object o) throws Exception {
        return o instanceof JsonObject;
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

