/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.query;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.index.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.QueryService;
import org.kie.kogito.index.query.UserTaskInstanceFilter;

@ApplicationScoped
public class InfinispanQueryService
implements QueryService {
    @Inject
    InfinispanCacheManager manager;

    public Collection<JsonObject> queryDomain(String domain, String query) {
        if (query == null) {
            return this.manager.getDomainModelCache(domain).values();
        }
        QueryFactory qf = Search.getQueryFactory((RemoteCache)((RemoteCache)this.manager.getDomainModelCache(domain)));
        Query q = qf.create(query);
        return q.list().stream().map(json -> Json.createReader((Reader)new StringReader((String)json)).readObject()).collect(Collectors.toList());
    }

    public Collection<JsonObject> queryProcessInstances(ProcessInstanceFilter filter) {
        QueryFactory qf = Search.getQueryFactory((RemoteCache)((RemoteCache)this.manager.getProcessInstancesCache()));
        QueryBuilder qb = qf.from(ProcessInstance.class);
        if (filter != null) {
            FilterConditionContextQueryBuilder filterBuilder = this.filterList("state", filter.getState(), null, qb);
            filterBuilder = this.filterList("processId", filter.getProcessId(), filterBuilder, qb);
            this.filterList("id", filter.getId(), filterBuilder, qb);
            if (filter.getLimit() != null) {
                qb.maxResults(filter.getLimit().intValue());
            }
            if (filter.getOffset() != null) {
                qb.startOffset((long)filter.getOffset().intValue());
            }
        }
        return qb.build().list();
    }

    public Collection<JsonObject> queryUserTaskInstances(UserTaskInstanceFilter filter) {
        QueryFactory qf = Search.getQueryFactory((RemoteCache)((RemoteCache)this.manager.getUserTaskInstancesCache()));
        QueryBuilder qb = qf.from(UserTaskInstance.class);
        if (filter != null) {
            FilterConditionContextQueryBuilder filterBuilder = this.filterList("state", filter.getState(), null, qb);
            filterBuilder = this.filterList("processInstanceId", filter.getProcessInstanceId(), filterBuilder, qb);
            filterBuilder = this.filterList("id", filter.getId(), filterBuilder, qb);
            filterBuilder = this.filterList("actualOwner", filter.getActualOwner(), filterBuilder, qb);
            filterBuilder = this.filterList("potentialUsers", filter.getPotentialUsers(), filterBuilder, qb);
            this.filterList("potentialGroups", filter.getPotentialGroups(), filterBuilder, qb);
            if (filter.getLimit() != null) {
                qb.maxResults(filter.getLimit().intValue());
            }
            if (filter.getOffset() != null) {
                qb.startOffset((long)filter.getOffset().intValue());
            }
        }
        return qb.build().list();
    }

    private FilterConditionContextQueryBuilder filterList(String attribute, List values, FilterConditionContextQueryBuilder filter, QueryBuilder qb) {
        if (values == null || values.isEmpty()) {
            return filter;
        }
        if (filter == null) {
            return qb.having(attribute).in((Collection)values);
        }
        return filter.and().having(attribute).in((Collection)values);
    }
}

