/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.infinispan.schema;

import io.quarkus.qute.Template;
import io.quarkus.qute.api.ResourcePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.infinispan.schema.ProtoSchemaAcceptor;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaRegistrationException;
import org.kie.kogito.persistence.infinispan.cache.ProtobufCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtoSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoSchemaManager.class);
    @Inject
    ProtoSchemaAcceptor schemaAcceptor;
    @Inject
    DataIndexStorageService cacheManager;
    @Inject
    RemoteCacheManager manager;
    @Inject
    ProtobufCacheService protobufCacheService;
    @ResourcePath(value="kogito-cache-default.xml")
    Template cacheTemplate;

    public void onSchemaRegisteredEvent(@Observes SchemaRegisteredEvent event) {
        if (this.schemaAcceptor.accept(event.getSchemaType())) {
            SchemaDescriptor schemaDescriptor = event.getSchemaDescriptor();
            Storage cache = this.protobufCacheService.getProtobufCache();
            cache.put((Object)schemaDescriptor.getName(), (Object)schemaDescriptor.getSchemaContent());
            schemaDescriptor.getProcessDescriptor().ifPresent(processDescriptor -> {
                this.cacheManager.getProcessIdModelCache().put((Object)processDescriptor.getProcessId(), (Object)processDescriptor.getProcessType());
                String cacheName = this.cacheManager.getDomainModelCacheName(processDescriptor.getProcessId());
                String cacheTemplateRendered = this.getTemplateRendered(schemaDescriptor, cacheName);
                LOGGER.debug("Cache template: \n{}", (Object)cacheTemplateRendered);
                this.manager.administration().getOrCreateCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(cacheTemplateRendered));
            });
            List<String> errors = this.checkSchemaErrors((Storage<String, String>)cache);
            if (!errors.isEmpty()) {
                String message = "Proto Schema contain errors:\n" + String.join((CharSequence)"\n", errors);
                throw new SchemaRegistrationException(message);
            }
            if (LOGGER.isDebugEnabled()) {
                this.logProtoCacheKeys();
            }
        }
    }

    private String getTemplateRendered(SchemaDescriptor schemaDescriptor, String cacheName) {
        return this.cacheTemplate.data("cache_name", (Object)cacheName).data("indexed", schemaDescriptor.getEntityIndexDescriptors().keySet()).render();
    }

    private List<String> checkSchemaErrors(Storage<String, String> metadataCache) {
        if (metadataCache.containsKey((Object)".errors")) {
            ArrayList<String> errors = new ArrayList<String>();
            String files = (String)metadataCache.get((Object)".errors");
            for (String fname : files.split("\n")) {
                String errorKey = fname + ".errors";
                String error = (String)metadataCache.get((Object)errorKey);
                LOGGER.warn("Found errors in Protobuf schema file: {}\n{}\n", (Object)fname, (Object)error);
                errors.add(String.format("Protobuf schema file: %s%n%s%n", fname, error));
            }
            return errors;
        }
        return Collections.emptyList();
    }

    private void logProtoCacheKeys() {
        LOGGER.debug(">>>>>>list cache keys start");
        this.protobufCacheService.getProtobufCache().entrySet().forEach(e -> LOGGER.debug(e.toString()));
        LOGGER.debug(">>>>>>list cache keys end");
    }
}

