/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.mapper;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.kogito.index.jpa.mapper.ProcessDefinitionEntityMapper;
import org.kie.kogito.index.jpa.model.NodeEntity;
import org.kie.kogito.index.jpa.model.ProcessDefinitionEntity;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.ProcessDefinition;

@ApplicationScoped
public class ProcessDefinitionEntityMapperImpl
implements ProcessDefinitionEntityMapper {
    @Override
    public ProcessDefinitionEntity mapToEntity(ProcessDefinition pd) {
        Set set1;
        if (pd == null) {
            return null;
        }
        ProcessDefinitionEntity processDefinitionEntity = new ProcessDefinitionEntity();
        processDefinitionEntity.setId(pd.getId());
        processDefinitionEntity.setVersion(pd.getVersion());
        processDefinitionEntity.setName(pd.getName());
        Set set = pd.getRoles();
        if (set != null) {
            processDefinitionEntity.setRoles(new LinkedHashSet<String>(set));
        }
        if ((set1 = pd.getAddons()) != null) {
            processDefinitionEntity.setAddons(new LinkedHashSet<String>(set1));
        }
        processDefinitionEntity.setType(pd.getType());
        processDefinitionEntity.setEndpoint(pd.getEndpoint());
        processDefinitionEntity.setSource(this.map(pd.getSource()));
        processDefinitionEntity.setNodes(this.nodeListToNodeEntityList(pd.getNodes()));
        processDefinitionEntity.setDescription(pd.getDescription());
        Set set2 = pd.getAnnotations();
        if (set2 != null) {
            processDefinitionEntity.setAnnotations(new LinkedHashSet<String>(set2));
        }
        processDefinitionEntity.setMetadata(this.map(pd.getMetadata()));
        this.afterMapping(processDefinitionEntity);
        return processDefinitionEntity;
    }

    @Override
    public ProcessDefinition mapToModel(ProcessDefinitionEntity pd) {
        Set<String> set1;
        if (pd == null) {
            return null;
        }
        ProcessDefinition processDefinition = new ProcessDefinition();
        processDefinition.setId(pd.getId());
        processDefinition.setName(pd.getName());
        Set<String> set = pd.getRoles();
        if (set != null) {
            processDefinition.setRoles(new LinkedHashSet<String>(set));
        }
        if ((set1 = pd.getAddons()) != null) {
            processDefinition.setAddons(new LinkedHashSet<String>(set1));
        }
        processDefinition.setVersion(pd.getVersion());
        processDefinition.setType(pd.getType());
        processDefinition.setEndpoint(pd.getEndpoint());
        processDefinition.setSource(this.map(pd.getSource()));
        processDefinition.setNodes(this.nodeEntityListToNodeList(pd.getNodes()));
        processDefinition.setDescription(pd.getDescription());
        Set<String> set2 = pd.getAnnotations();
        if (set2 != null) {
            processDefinition.setAnnotations(new LinkedHashSet<String>(set2));
        }
        processDefinition.setMetadata(this.map(pd.getMetadata()));
        return processDefinition;
    }

    protected NodeEntity nodeToNodeEntity(Node node) {
        if (node == null) {
            return null;
        }
        NodeEntity nodeEntity = new NodeEntity();
        nodeEntity.setId(node.getId());
        nodeEntity.setName(node.getName());
        nodeEntity.setUniqueId(node.getUniqueId());
        nodeEntity.setType(node.getType());
        Map map = node.getMetadata();
        if (map != null) {
            nodeEntity.setMetadata(new LinkedHashMap<String, String>(map));
        }
        return nodeEntity;
    }

    protected List<NodeEntity> nodeListToNodeEntityList(List<Node> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NodeEntity> list1 = new ArrayList<NodeEntity>(list.size());
        for (Node node : list) {
            list1.add(this.nodeToNodeEntity(node));
        }
        return list1;
    }

    protected Node nodeEntityToNode(NodeEntity nodeEntity) {
        if (nodeEntity == null) {
            return null;
        }
        Node node = new Node();
        node.setId(nodeEntity.getId());
        node.setName(nodeEntity.getName());
        node.setType(nodeEntity.getType());
        node.setUniqueId(nodeEntity.getUniqueId());
        Map<String, String> map = nodeEntity.getMetadata();
        if (map != null) {
            node.setMetadata(new LinkedHashMap<String, String>(map));
        }
        return node;
    }

    protected List<Node> nodeEntityListToNodeList(List<NodeEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Node> list1 = new ArrayList<Node>(list.size());
        for (NodeEntity nodeEntity : list) {
            list1.add(this.nodeEntityToNode(nodeEntity));
        }
        return list1;
    }
}

