/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.mapper;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.kie.kogito.index.jpa.mapper.ProcessInstanceEntityMapper;
import org.kie.kogito.index.jpa.model.MilestoneEntity;
import org.kie.kogito.index.jpa.model.NodeInstanceEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceErrorEntity;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;

@ApplicationScoped
public class ProcessInstanceEntityMapperImpl
implements ProcessInstanceEntityMapper {
    @Override
    public MilestoneEntity mapMilestoneToEntity(Milestone mi) {
        if (mi == null) {
            return null;
        }
        MilestoneEntity milestoneEntity = new MilestoneEntity();
        milestoneEntity.setId(mi.getId());
        milestoneEntity.setName(mi.getName());
        milestoneEntity.setStatus(mi.getStatus());
        return milestoneEntity;
    }

    @Override
    public Milestone mapMilestoneToModel(MilestoneEntity pi) {
        if (pi == null) {
            return null;
        }
        Milestone.Builder milestone = Milestone.builder();
        milestone.id(pi.getId());
        milestone.name(pi.getName());
        milestone.status(pi.getStatus());
        return milestone.build();
    }

    @Override
    public ProcessInstanceEntity mapToEntity(ProcessInstance pi) {
        if (pi == null) {
            return null;
        }
        ProcessInstanceEntity processInstanceEntity = new ProcessInstanceEntity();
        processInstanceEntity.setId(pi.getId());
        processInstanceEntity.setProcessId(pi.getProcessId());
        processInstanceEntity.setProcessName(pi.getProcessName());
        processInstanceEntity.setState(pi.getState());
        processInstanceEntity.setBusinessKey(pi.getBusinessKey());
        processInstanceEntity.setEndpoint(pi.getEndpoint());
        Set set = pi.getRoles();
        if (set != null) {
            processInstanceEntity.setRoles(new LinkedHashSet<String>(set));
        }
        processInstanceEntity.setStart(pi.getStart());
        processInstanceEntity.setEnd(pi.getEnd());
        processInstanceEntity.setRootProcessInstanceId(pi.getRootProcessInstanceId());
        processInstanceEntity.setRootProcessId(pi.getRootProcessId());
        processInstanceEntity.setParentProcessInstanceId(pi.getParentProcessInstanceId());
        processInstanceEntity.setLastUpdate(pi.getLastUpdate());
        processInstanceEntity.setCreatedBy(pi.getCreatedBy());
        processInstanceEntity.setUpdatedBy(pi.getUpdatedBy());
        processInstanceEntity.setSlaDueDate(pi.getSlaDueDate());
        processInstanceEntity.setVariables(pi.getVariables());
        processInstanceEntity.setNodes(this.nodeInstanceListToNodeInstanceEntityList(pi.getNodes()));
        processInstanceEntity.setMilestones(this.milestoneListToMilestoneEntityList(pi.getMilestones()));
        Set set1 = pi.getAddons();
        if (set1 != null) {
            processInstanceEntity.setAddons(new LinkedHashSet<String>(set1));
        }
        processInstanceEntity.setError(this.processInstanceErrorToProcessInstanceErrorEntity(pi.getError()));
        processInstanceEntity.setVersion(pi.getVersion());
        this.afterMapping(processInstanceEntity);
        return processInstanceEntity;
    }

    @Override
    public ProcessInstance mapToModel(ProcessInstanceEntity pi) {
        if (pi == null) {
            return null;
        }
        ProcessInstance processInstance = new ProcessInstance();
        processInstance.setId(pi.getId());
        processInstance.setProcessId(pi.getProcessId());
        processInstance.setEndpoint(pi.getEndpoint());
        processInstance.setState(pi.getState());
        processInstance.setBusinessKey(pi.getBusinessKey());
        Set<String> set = pi.getRoles();
        if (set != null) {
            processInstance.setRoles(new LinkedHashSet<String>(set));
        }
        processInstance.setStart(pi.getStart());
        processInstance.setEnd(pi.getEnd());
        processInstance.setRootProcessInstanceId(pi.getRootProcessInstanceId());
        processInstance.setRootProcessId(pi.getRootProcessId());
        processInstance.setParentProcessInstanceId(pi.getParentProcessInstanceId());
        processInstance.setProcessName(pi.getProcessName());
        processInstance.setLastUpdate(pi.getLastUpdate());
        processInstance.setVersion(pi.getVersion());
        processInstance.setCreatedBy(pi.getCreatedBy());
        processInstance.setUpdatedBy(pi.getUpdatedBy());
        processInstance.setSlaDueDate(pi.getSlaDueDate());
        processInstance.setVariables(pi.getVariables());
        processInstance.setNodes(this.nodeInstanceEntityListToNodeInstanceList(pi.getNodes()));
        processInstance.setError(this.processInstanceErrorEntityToProcessInstanceError(pi.getError()));
        Set<String> set1 = pi.getAddons();
        if (set1 != null) {
            processInstance.setAddons(new LinkedHashSet<String>(set1));
        }
        processInstance.setMilestones(this.milestoneEntityListToMilestoneList(pi.getMilestones()));
        return processInstance;
    }

    protected NodeInstanceEntity nodeInstanceToNodeInstanceEntity(NodeInstance nodeInstance) {
        if (nodeInstance == null) {
            return null;
        }
        NodeInstanceEntity nodeInstanceEntity = new NodeInstanceEntity();
        nodeInstanceEntity.setRetrigger(nodeInstance.isRetrigger());
        nodeInstanceEntity.setErrorMessage(nodeInstance.getErrorMessage());
        nodeInstanceEntity.setId(nodeInstance.getId());
        nodeInstanceEntity.setName(nodeInstance.getName());
        nodeInstanceEntity.setNodeId(nodeInstance.getNodeId());
        nodeInstanceEntity.setType(nodeInstance.getType());
        nodeInstanceEntity.setDefinitionId(nodeInstance.getDefinitionId());
        nodeInstanceEntity.setEnter(nodeInstance.getEnter());
        nodeInstanceEntity.setExit(nodeInstance.getExit());
        nodeInstanceEntity.setSlaDueDate(nodeInstance.getSlaDueDate());
        return nodeInstanceEntity;
    }

    protected List<NodeInstanceEntity> nodeInstanceListToNodeInstanceEntityList(List<NodeInstance> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NodeInstanceEntity> list1 = new ArrayList<NodeInstanceEntity>(list.size());
        for (NodeInstance nodeInstance : list) {
            list1.add(this.nodeInstanceToNodeInstanceEntity(nodeInstance));
        }
        return list1;
    }

    protected List<MilestoneEntity> milestoneListToMilestoneEntityList(List<Milestone> list) {
        if (list == null) {
            return null;
        }
        ArrayList<MilestoneEntity> list1 = new ArrayList<MilestoneEntity>(list.size());
        for (Milestone milestone : list) {
            list1.add(this.mapMilestoneToEntity(milestone));
        }
        return list1;
    }

    protected ProcessInstanceErrorEntity processInstanceErrorToProcessInstanceErrorEntity(ProcessInstanceError processInstanceError) {
        if (processInstanceError == null) {
            return null;
        }
        ProcessInstanceErrorEntity processInstanceErrorEntity = new ProcessInstanceErrorEntity();
        processInstanceErrorEntity.setNodeDefinitionId(processInstanceError.getNodeDefinitionId());
        processInstanceErrorEntity.setMessage(processInstanceError.getMessage());
        processInstanceErrorEntity.setNodeInstanceId(processInstanceError.getNodeInstanceId());
        return processInstanceErrorEntity;
    }

    protected NodeInstance nodeInstanceEntityToNodeInstance(NodeInstanceEntity nodeInstanceEntity) {
        if (nodeInstanceEntity == null) {
            return null;
        }
        NodeInstance nodeInstance = new NodeInstance();
        nodeInstance.setRetrigger(nodeInstanceEntity.isRetrigger());
        nodeInstance.setErrorMessage(nodeInstanceEntity.getErrorMessage());
        nodeInstance.setId(nodeInstanceEntity.getId());
        nodeInstance.setEnter(nodeInstanceEntity.getEnter());
        nodeInstance.setExit(nodeInstanceEntity.getExit());
        nodeInstance.setNodeId(nodeInstanceEntity.getNodeId());
        nodeInstance.setDefinitionId(nodeInstanceEntity.getDefinitionId());
        nodeInstance.setType(nodeInstanceEntity.getType());
        nodeInstance.setName(nodeInstanceEntity.getName());
        nodeInstance.setSlaDueDate(nodeInstanceEntity.getSlaDueDate());
        return nodeInstance;
    }

    protected List<NodeInstance> nodeInstanceEntityListToNodeInstanceList(List<NodeInstanceEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<NodeInstance> list1 = new ArrayList<NodeInstance>(list.size());
        for (NodeInstanceEntity nodeInstanceEntity : list) {
            list1.add(this.nodeInstanceEntityToNodeInstance(nodeInstanceEntity));
        }
        return list1;
    }

    protected ProcessInstanceError processInstanceErrorEntityToProcessInstanceError(ProcessInstanceErrorEntity processInstanceErrorEntity) {
        if (processInstanceErrorEntity == null) {
            return null;
        }
        ProcessInstanceError processInstanceError = new ProcessInstanceError();
        processInstanceError.setNodeDefinitionId(processInstanceErrorEntity.getNodeDefinitionId());
        processInstanceError.setMessage(processInstanceErrorEntity.getMessage());
        processInstanceError.setNodeInstanceId(processInstanceErrorEntity.getNodeInstanceId());
        return processInstanceError;
    }

    protected List<Milestone> milestoneEntityListToMilestoneList(List<MilestoneEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Milestone> list1 = new ArrayList<Milestone>(list.size());
        for (MilestoneEntity milestoneEntity : list) {
            list1.add(this.mapMilestoneToModel(milestoneEntity));
        }
        return list1;
    }
}

