/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.Table;
import java.util.Map;
import java.util.Objects;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.model.NodeEntityId;
import org.kie.kogito.index.jpa.model.ProcessDefinitionEntity;

@Entity(name="definitions_nodes")
@Table(name="definitions_nodes")
@IdClass(value=NodeEntityId.class)
public class NodeEntity
extends AbstractEntity {
    @Id
    private String id;
    private String name;
    private String uniqueId;
    private String type;
    @ElementCollection
    @CollectionTable(name="definitions_nodes_metadata", joinColumns={@JoinColumn(name="node_id", referencedColumnName="id"), @JoinColumn(name="process_id", referencedColumnName="process_id"), @JoinColumn(name="process_version", referencedColumnName="process_version")}, foreignKey=@ForeignKey(name="fk_definitions_nodes_metadata_definitions_nodes"))
    @MapKeyColumn(name="name")
    @Column(name="meta_value")
    private Map<String, String> metadata;
    @Id
    @ManyToOne(cascade={CascadeType.ALL}, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumns(value={@JoinColumn(name="process_id"), @JoinColumn(name="process_version")}, foreignKey=@ForeignKey(name="fk_definitions_nodes_definitions"))
    private ProcessDefinitionEntity processDefinition;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String nodeId) {
        this.uniqueId = nodeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ProcessDefinitionEntity getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinition = processDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeEntity that = (NodeEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "NodeEntity{id='" + this.id + "', name='" + this.name + "', uniqueId='" + this.uniqueId + "', type='" + this.type + "', metadata=" + this.metadata + "}";
    }
}

