/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceEntity;

@Entity(name="nodes")
@Table(name="nodes")
public class NodeInstanceEntity
extends AbstractEntity {
    @Id
    private String id;
    private String name;
    private String nodeId;
    private String type;
    private ZonedDateTime enter;
    private ZonedDateTime exit;
    private ZonedDateTime slaDueDate;
    private String definitionId;
    private Boolean retrigger;
    private String errorMessage;
    @ManyToOne(cascade={CascadeType.ALL}, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumn(name="processInstanceId", foreignKey=@ForeignKey(name="fk_nodes_process"))
    private ProcessInstanceEntity processInstance;

    public Boolean isRetrigger() {
        return this.retrigger;
    }

    public void setRetrigger(Boolean isRetrigger) {
        this.retrigger = isRetrigger;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public ZonedDateTime getEnter() {
        return this.enter;
    }

    public void setEnter(ZonedDateTime enter) {
        this.enter = enter;
    }

    public ZonedDateTime getExit() {
        return this.exit;
    }

    public void setExit(ZonedDateTime exit) {
        this.exit = exit;
    }

    public ZonedDateTime getSlaDueDate() {
        return this.slaDueDate;
    }

    public void setSlaDueDate(ZonedDateTime slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public ProcessInstanceEntity getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstanceEntity processInstance) {
        this.processInstance = processInstance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInstanceEntity that = (NodeInstanceEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

