/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.model.NodeEntity;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryConverter;

@Entity(name="definitions")
@Table(name="definitions")
@IdClass(value=ProcessDefinitionKey.class)
public class ProcessDefinitionEntity
extends AbstractEntity {
    @Id
    private String id;
    @Id
    private String version;
    private String name;
    private String description;
    private String type;
    private byte[] source;
    @ElementCollection
    @CollectionTable(name="definitions_roles", joinColumns={@JoinColumn(name="process_id"), @JoinColumn(name="process_version")}, foreignKey=@ForeignKey(name="fk_definitions_roles_definitions"))
    @Column(name="role", nullable=false)
    private Set<String> roles;
    @ElementCollection
    @CollectionTable(name="definitions_addons", joinColumns={@JoinColumn(name="process_id"), @JoinColumn(name="process_version")}, foreignKey=@ForeignKey(name="fk_definitions_addons_definitions"))
    @Column(name="addon", nullable=false)
    private Set<String> addons;
    private String endpoint;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processDefinition")
    private List<NodeEntity> nodes;
    @ElementCollection
    @CollectionTable(name="definitions_annotations", joinColumns={@JoinColumn(name="process_id", referencedColumnName="id"), @JoinColumn(name="process_version", referencedColumnName="version")}, foreignKey=@ForeignKey(name="fk_definitions_annotations"))
    @Column(name="annotation")
    private Set<String> annotations;
    @Convert(converter=JsonBinaryConverter.class)
    @Column(columnDefinition="jsonb")
    private ObjectNode metadata;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setAddons(Set<String> addons) {
        this.addons = addons;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<String> getAddons() {
        return this.addons;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public byte[] getSource() {
        return this.source;
    }

    public void setSource(byte[] source) {
        this.source = source;
    }

    public List<NodeEntity> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NodeEntity> nodes) {
        this.nodes = nodes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
    }

    public ObjectNode getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectNode metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDefinitionEntity that = (ProcessDefinitionEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        return "ProcessDefinitionEntity{id='" + this.id + "', version='" + this.version + "', name='" + this.name + "', type='" + this.type + "', endpoint='" + this.endpoint + "'}";
    }
}

