/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.model.MilestoneEntity;
import org.kie.kogito.index.jpa.model.NodeInstanceEntity;
import org.kie.kogito.index.jpa.model.ProcessDefinitionEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceErrorEntity;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryConverter;

@Entity(name="processes")
@Table(name="processes")
public class ProcessInstanceEntity
extends AbstractEntity {
    @Id
    private String id;
    private String processId;
    private String version;
    private String processName;
    private Integer state;
    private String businessKey;
    private String endpoint;
    @ElementCollection
    @CollectionTable(name="processes_roles", joinColumns={@JoinColumn(name="process_id", foreignKey=@ForeignKey(name="fk_processes_roles_processes"))})
    @Column(name="role", nullable=false)
    private Set<String> roles;
    @Column(name="startTime")
    private ZonedDateTime start;
    @Column(name="endTime")
    private ZonedDateTime end;
    private String rootProcessInstanceId;
    private String rootProcessId;
    private String parentProcessInstanceId;
    @Column(name="lastUpdateTime")
    private ZonedDateTime lastUpdate;
    private String createdBy;
    private String updatedBy;
    private ZonedDateTime slaDueDate;
    @Convert(converter=JsonBinaryConverter.class)
    @Column(columnDefinition="jsonb")
    private ObjectNode variables;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<NodeInstanceEntity> nodes;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<MilestoneEntity> milestones;
    @ElementCollection
    @CollectionTable(name="processes_addons", joinColumns={@JoinColumn(name="process_id", foreignKey=@ForeignKey(name="fk_processes_addons_processes"))})
    @Column(name="addon", nullable=false)
    private Set<String> addons;
    @Embedded
    private ProcessInstanceErrorEntity error;
    @ManyToOne(targetEntity=ProcessDefinitionEntity.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="processId", referencedColumnName="id", insertable=false, updatable=false), @JoinColumn(name="version", referencedColumnName="version", insertable=false, updatable=false)})
    private ProcessDefinitionEntity definition;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public void setEnd(ZonedDateTime end) {
        this.end = end;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public void setRootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String identity) {
        this.createdBy = identity;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public ZonedDateTime getSlaDueDate() {
        return this.slaDueDate;
    }

    public void setSlaDueDate(ZonedDateTime slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public ObjectNode getVariables() {
        return this.variables;
    }

    public void setVariables(ObjectNode variables) {
        this.variables = variables;
    }

    public List<NodeInstanceEntity> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<NodeInstanceEntity> nodes) {
        this.nodes = nodes;
    }

    public List<MilestoneEntity> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<MilestoneEntity> milestones) {
        this.milestones = milestones;
    }

    public Set<String> getAddons() {
        return this.addons;
    }

    public void setAddons(Set<String> addons) {
        this.addons = addons;
    }

    public ProcessInstanceErrorEntity getError() {
        return this.error;
    }

    public void setError(ProcessInstanceErrorEntity error) {
        this.error = error;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceEntity that = (ProcessInstanceEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ProcessInstanceEntity{id='" + this.id + "', processId='" + this.processId + "', processName='" + this.processName + "', state=" + this.state + ", businessKey='" + this.businessKey + "', endpoint='" + this.endpoint + "', roles=" + this.roles + ", start=" + this.start + ", end=" + this.end + ", rootProcessInstanceId='" + this.rootProcessInstanceId + "', rootProcessId='" + this.rootProcessId + "', parentProcessInstanceId='" + this.parentProcessInstanceId + "', lastUpdate=" + this.lastUpdate + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", slaDueDate=" + this.slaDueDate + ", variables=" + this.variables + ", nodes=" + this.nodes + ", milestones=" + this.milestones + ", addons=" + this.addons + ", error=" + this.error + ", version=" + this.version + "}";
    }
}

