/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.smallrye.mutiny.Multi;
import jakarta.transaction.Transactional;
import java.util.function.Function;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.storage.JPAQuery;
import org.kie.kogito.persistence.api.StorageFetcher;
import org.kie.kogito.persistence.api.query.Query;

public class AbstractJPAStorageFetcher<K, E extends AbstractEntity, V>
implements StorageFetcher<K, V> {
    private static final String LISTENER_NOT_AVAILABLE_IN_JPA = "Listener not available in JPA database";
    protected PanacheRepositoryBase<E, K> repository;
    protected Class<E> entityClass;
    protected Function<E, V> mapToModel;

    protected AbstractJPAStorageFetcher() {
    }

    protected AbstractJPAStorageFetcher(PanacheRepositoryBase<E, K> repository, Class<E> entityClass, Function<E, V> mapToModel) {
        this.repository = repository;
        this.entityClass = entityClass;
        this.mapToModel = mapToModel;
    }

    public Multi<V> objectCreatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_JPA);
    }

    public Multi<V> objectUpdatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_JPA);
    }

    public Multi<K> objectRemovedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_JPA);
    }

    public Query<V> query() {
        return new JPAQuery<K, E, V>(this.repository, this.mapToModel, this.entityClass);
    }

    @Transactional
    public V get(K key) {
        return this.repository.findByIdOptional(key).map(this.mapToModel).orElse(null);
    }

    @Transactional
    public void clear() {
        this.repository.deleteAll();
    }
}

