/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import jakarta.transaction.Transactional;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.index.jpa.storage.AbstractJPAStorageFetcher;
import org.kie.kogito.persistence.api.Storage;

public abstract class AbstractStorage<K, E extends AbstractEntity, V>
extends AbstractJPAStorageFetcher<K, E, V>
implements Storage<K, V> {
    private Class<V> modelClass;
    private Function<V, E> mapToEntity;
    private Function<E, K> mapEntityToKey;

    protected AbstractStorage() {
    }

    protected AbstractStorage(PanacheRepositoryBase<E, K> repository, Class<V> modelClass, Class<E> entityClass, Function<E, V> mapToModel, Function<V, E> mapToEntity, Function<E, K> mapEntityToKey) {
        super(repository, entityClass, mapToModel);
        this.modelClass = modelClass;
        this.mapToEntity = mapToEntity;
        this.mapEntityToKey = mapEntityToKey;
    }

    @Transactional
    public V put(K key, V value) {
        this.repository.getEntityManager().merge((Object)((AbstractEntity)this.mapToEntity.apply(value)));
        return value;
    }

    @Transactional
    public V remove(K key) {
        Object value = this.get(key);
        if (value != null) {
            this.repository.deleteById(key);
        }
        return value;
    }

    @Transactional
    public boolean containsKey(K key) {
        return this.repository.count("id = ?1", new Object[]{key}) == 1L;
    }

    public Map<K, V> entries() {
        return this.repository.streamAll().collect(Collectors.toMap(this.mapEntityToKey, this.mapToModel));
    }

    @Override
    @Transactional
    public void clear() {
        this.repository.deleteAll();
    }

    public String getRootType() {
        return this.modelClass.getCanonicalName();
    }

    protected PanacheRepositoryBase<E, K> getRepository() {
        return this.repository;
    }
}

