/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.index.jpa.model.AbstractEntity;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.SortDirection;

public class JPAQuery<K, E extends AbstractEntity, T>
implements Query<T> {
    protected final PanacheRepositoryBase<E, K> repository;
    private Integer limit;
    private Integer offset;
    private List<AttributeFilter<?>> filters;
    private List<AttributeSort> sortBy;
    protected final Class<E> entityClass;
    protected final Function<E, T> mapper;

    public JPAQuery(PanacheRepositoryBase<E, K> repository, Function<E, T> mapper, Class<E> entityClass) {
        this.repository = repository;
        this.mapper = mapper;
        this.entityClass = entityClass;
    }

    public Query<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query<T> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    public Query<T> sort(List<AttributeSort> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<T> execute() {
        CriteriaBuilder builder = this.repository.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        this.addWhere(builder, criteriaQuery, root);
        if (this.sortBy != null && !this.sortBy.isEmpty()) {
            List orderBy = this.sortBy.stream().map(f -> {
                Path attributePath = this.getAttributePath(root, f.getAttribute());
                return f.getSort() == SortDirection.ASC ? builder.asc((Expression)attributePath) : builder.desc((Expression)attributePath);
            }).collect(Collectors.toList());
            criteriaQuery.orderBy(orderBy);
        }
        TypedQuery query = this.repository.getEntityManager().createQuery(criteriaQuery);
        if (this.limit != null) {
            query.setMaxResults(this.limit.intValue());
        }
        if (this.offset != null) {
            query.setFirstResult(this.offset.intValue());
        }
        return query.getResultList().stream().map(this.mapper).collect(Collectors.toList());
    }

    protected Function<AttributeFilter<?>, Predicate> filterPredicateFunction(Root<E> root, CriteriaBuilder builder) {
        return filter -> this.buildPredicateFunction((AttributeFilter)filter, root, builder);
    }

    protected final Predicate buildPredicateFunction(AttributeFilter filter, Root<E> root, CriteriaBuilder builder) {
        switch (filter.getCondition()) {
            case CONTAINS: {
                return builder.isMember(filter.getValue(), (Expression)this.getAttributePath(root, filter.getAttribute()));
            }
            case CONTAINS_ALL: {
                List<Predicate> predicatesAll = ((List)filter.getValue()).stream().map(o -> builder.isMember(o, (Expression)this.getAttributePath(root, filter.getAttribute()))).collect(Collectors.toList());
                return builder.and(predicatesAll.toArray(new Predicate[0]));
            }
            case CONTAINS_ANY: {
                List<Predicate> predicatesAny = ((List)filter.getValue()).stream().map(o -> builder.isMember(o, (Expression)this.getAttributePath(root, filter.getAttribute()))).collect(Collectors.toList());
                return builder.or(predicatesAny.toArray(new Predicate[0]));
            }
            case IN: {
                return this.getAttributePath(root, filter.getAttribute()).in((Collection)filter.getValue());
            }
            case LIKE: {
                return builder.like((Expression)this.getAttributePath(root, filter.getAttribute()), filter.getValue().toString().replaceAll("\\*", "%"));
            }
            case EQUAL: {
                return builder.equal((Expression)this.getAttributePath(root, filter.getAttribute()), filter.getValue());
            }
            case IS_NULL: {
                Path pathNull = this.getAttributePath(root, filter.getAttribute());
                return this.isPluralAttribute(filter.getAttribute()) ? builder.isEmpty((Expression)pathNull) : builder.isNull((Expression)pathNull);
            }
            case NOT_NULL: {
                Path pathNotNull = this.getAttributePath(root, filter.getAttribute());
                return this.isPluralAttribute(filter.getAttribute()) ? builder.isNotEmpty((Expression)pathNotNull) : builder.isNotNull((Expression)pathNotNull);
            }
            case BETWEEN: {
                List value = (List)filter.getValue();
                return builder.between((Expression)this.getAttributePath(root, filter.getAttribute()), (Comparable)value.get(0), (Comparable)value.get(1));
            }
            case GT: {
                return builder.greaterThan((Expression)this.getAttributePath(root, filter.getAttribute()), (Comparable)filter.getValue());
            }
            case GTE: {
                return builder.greaterThanOrEqualTo((Expression)this.getAttributePath(root, filter.getAttribute()), (Comparable)filter.getValue());
            }
            case LT: {
                return builder.lessThan((Expression)this.getAttributePath(root, filter.getAttribute()), (Comparable)filter.getValue());
            }
            case LTE: {
                return builder.lessThanOrEqualTo((Expression)this.getAttributePath(root, filter.getAttribute()), (Comparable)filter.getValue());
            }
            case OR: {
                return builder.or(this.getRecursivePredicate(filter, root, builder).toArray(new Predicate[0]));
            }
            case AND: {
                return builder.and(this.getRecursivePredicate(filter, root, builder).toArray(new Predicate[0]));
            }
            case NOT: {
                return builder.not((Expression)this.filterPredicateFunction(root, builder).apply((AttributeFilter)filter.getValue()));
            }
        }
        return null;
    }

    private Path getAttributePath(Root<E> root, String attribute) {
        String[] split = attribute.split("\\.");
        if (split.length == 1) {
            return root.get(attribute);
        }
        Join join = root.join(split[0]);
        for (int i = 1; i < split.length - 1; ++i) {
            join = join.join(split[i]);
        }
        return join.get(split[split.length - 1]);
    }

    private boolean isPluralAttribute(String attribute) {
        return this.repository.getEntityManager().getMetamodel().entity(this.entityClass).getDeclaredPluralAttributes().stream().map(Attribute::getName).anyMatch(pluralAttribute -> pluralAttribute.equals(attribute));
    }

    private List<Predicate> getRecursivePredicate(AttributeFilter<?> filter, Root<E> root, CriteriaBuilder builder) {
        return ((List)filter.getValue()).stream().map(this.filterPredicateFunction(root, builder)).collect(Collectors.toList());
    }

    public long count() {
        CriteriaBuilder builder = this.repository.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.select((Selection)builder.count((Expression)root));
        this.addWhere(builder, criteriaQuery, root);
        return (Long)this.repository.getEntityManager().createQuery(criteriaQuery).getSingleResult();
    }

    private <V> void addWhere(CriteriaBuilder builder, CriteriaQuery<V> criteriaQuery, Root<E> root) {
        if (this.filters != null && !this.filters.isEmpty()) {
            criteriaQuery.where((Predicate[])this.filters.stream().map(this.filterPredicateFunction(root, builder)).toArray(Predicate[]::new));
        }
    }
}

