/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.storage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.kie.kogito.event.process.MultipleProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeEventBody;
import org.kie.kogito.event.process.ProcessInstanceSLADataEvent;
import org.kie.kogito.event.process.ProcessInstanceSLAEventBody;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateEventBody;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.jpa.mapper.ProcessInstanceEntityMapper;
import org.kie.kogito.index.jpa.model.MilestoneEntity;
import org.kie.kogito.index.jpa.model.NodeInstanceEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceEntity;
import org.kie.kogito.index.jpa.model.ProcessInstanceEntityRepository;
import org.kie.kogito.index.jpa.model.ProcessInstanceErrorEntity;
import org.kie.kogito.index.jpa.storage.AbstractJPAStorageFetcher;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.MilestoneStatus;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.storage.ProcessInstanceStorage;
import org.kie.kogito.persistence.api.StorageServiceCapability;

@ApplicationScoped
@DefaultBean
public class ProcessInstanceEntityStorage
extends AbstractJPAStorageFetcher<String, ProcessInstanceEntity, ProcessInstance>
implements ProcessInstanceStorage {
    protected ProcessInstanceEntityStorage() {
    }

    @Inject
    public ProcessInstanceEntityStorage(ProcessInstanceEntityRepository repository, ProcessInstanceEntityMapper mapper) {
        super(repository, ProcessInstanceEntity.class, mapper::mapToModel);
    }

    @Transactional
    public void indexGroup(MultipleProcessInstanceDataEvent events) {
        HashMap<String, ProcessInstanceEntity> piMap = new HashMap<String, ProcessInstanceEntity>();
        for (ProcessInstanceDataEvent event : (Collection)events.getData()) {
            this.indexEvent(piMap.computeIfAbsent(event.getKogitoProcessInstanceId(), id -> this.findOrInit(event)), event);
        }
    }

    @Transactional
    public void indexError(ProcessInstanceErrorDataEvent event) {
        this.indexError(this.findOrInit((ProcessInstanceDataEvent<?>)event), (ProcessInstanceErrorEventBody)event.getData());
    }

    @Transactional
    public void indexNode(ProcessInstanceNodeDataEvent event) {
        this.indexNode(this.findOrInit((ProcessInstanceDataEvent<?>)event), (ProcessInstanceNodeEventBody)event.getData());
    }

    @Transactional
    public void indexSLA(ProcessInstanceSLADataEvent event) {
        this.indexSla(this.findOrInit((ProcessInstanceDataEvent<?>)event), (ProcessInstanceSLAEventBody)event.getData());
    }

    @Transactional
    public void indexState(ProcessInstanceStateDataEvent event) {
        this.indexState(this.findOrInit((ProcessInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexVariable(ProcessInstanceVariableDataEvent event) {
        this.indexVariable(this.findOrInit((ProcessInstanceDataEvent<?>)event), (ProcessInstanceVariableEventBody)event.getData());
    }

    private ProcessInstanceEntity findOrInit(ProcessInstanceDataEvent<?> event) {
        return this.repository.findByIdOptional((Object)event.getKogitoProcessInstanceId()).orElseGet(() -> {
            ProcessInstanceEntity pi = new ProcessInstanceEntity();
            pi.setProcessId(event.getKogitoProcessId());
            pi.setVersion(event.getKogitoProcessInstanceVersion());
            pi.setId(event.getKogitoProcessInstanceId());
            pi.setLastUpdate(DateTimeUtils.toZonedDateTime((OffsetDateTime)event.getTime()));
            pi.setNodes(new ArrayList<NodeInstanceEntity>());
            pi.setMilestones(new ArrayList<MilestoneEntity>());
            this.repository.persist((Object)pi);
            return pi;
        });
    }

    private void indexEvent(ProcessInstanceEntity pi, ProcessInstanceDataEvent<?> event) {
        if (event instanceof ProcessInstanceErrorDataEvent) {
            this.indexError(pi, (ProcessInstanceErrorEventBody)((ProcessInstanceErrorDataEvent)event).getData());
        } else if (event instanceof ProcessInstanceNodeDataEvent) {
            this.indexNode(pi, (ProcessInstanceNodeEventBody)((ProcessInstanceNodeDataEvent)event).getData());
        } else if (event instanceof ProcessInstanceSLADataEvent) {
            this.indexSla(pi, (ProcessInstanceSLAEventBody)((ProcessInstanceSLADataEvent)event).getData());
        } else if (event instanceof ProcessInstanceStateDataEvent) {
            this.indexState(pi, (ProcessInstanceStateDataEvent)event);
        } else if (event instanceof ProcessInstanceVariableDataEvent) {
            this.indexVariable(pi, (ProcessInstanceVariableEventBody)((ProcessInstanceVariableDataEvent)event).getData());
        }
    }

    private void indexError(ProcessInstanceEntity pi, ProcessInstanceErrorEventBody error) {
        ProcessInstanceErrorEntity errorEntity = pi.getError();
        if (errorEntity == null) {
            errorEntity = new ProcessInstanceErrorEntity();
            pi.setError(errorEntity);
        }
        errorEntity.setMessage(error.getErrorMessage());
        errorEntity.setNodeDefinitionId(error.getNodeDefinitionId());
        errorEntity.setNodeInstanceId(error.getNodeInstanceId());
        pi.setState(5);
        pi.getNodes().stream().filter(n -> n.getId().equals(error.getNodeInstanceId())).findAny().ifPresent(n -> n.setErrorMessage(error.getErrorMessage()));
    }

    private void indexNode(ProcessInstanceEntity pi, ProcessInstanceNodeEventBody data) {
        pi.getNodes().stream().filter(n -> n.getId().equals(data.getNodeInstanceId())).findAny().ifPresentOrElse(n -> this.updateNode((NodeInstanceEntity)n, data), () -> this.createNode(pi, data));
        if ("MilestoneNode".equals(data.getNodeType())) {
            pi.getMilestones().stream().filter(n -> n.getId().equals(data.getNodeInstanceId())).findAny().ifPresentOrElse(n -> this.updateMilestone((MilestoneEntity)n, data), () -> this.createMilestone(pi, data));
        }
    }

    private MilestoneEntity createMilestone(ProcessInstanceEntity pi, ProcessInstanceNodeEventBody data) {
        MilestoneEntity milestone = new MilestoneEntity();
        milestone.setProcessInstance(pi);
        pi.getMilestones().add(milestone);
        return this.updateMilestone(milestone, data);
    }

    private MilestoneEntity updateMilestone(MilestoneEntity milestone, ProcessInstanceNodeEventBody body) {
        milestone.setId(body.getNodeInstanceId());
        milestone.setName(body.getNodeName());
        milestone.setStatus(body.getEventType() == 2 ? MilestoneStatus.COMPLETED.name() : MilestoneStatus.ACTIVE.name());
        return milestone;
    }

    private NodeInstanceEntity createNode(ProcessInstanceEntity pi, ProcessInstanceNodeEventBody data) {
        NodeInstanceEntity node = new NodeInstanceEntity();
        node.setProcessInstance(pi);
        this.updateNode(node, data);
        pi.getNodes().add(node);
        return node;
    }

    private NodeInstanceEntity updateNode(NodeInstanceEntity nodeInstance, ProcessInstanceNodeEventBody body) {
        nodeInstance.setDefinitionId(body.getNodeDefinitionId());
        nodeInstance.setId(body.getNodeInstanceId());
        nodeInstance.setNodeId(body.getNodeDefinitionId());
        nodeInstance.setName(body.getNodeName());
        nodeInstance.setType(body.getNodeType());
        nodeInstance.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)body.getSlaDueDate()));
        if (body.isRetrigger() != null) {
            nodeInstance.setRetrigger(body.isRetrigger());
        }
        ZonedDateTime eventDate = DateTimeUtils.toZonedDateTime((Date)body.getEventDate());
        switch (body.getEventType()) {
            case 1: {
                nodeInstance.setEnter(eventDate);
                break;
            }
            case 2: {
                nodeInstance.setExit(eventDate);
            }
            default: {
                if (nodeInstance.getEnter() != null) break;
                nodeInstance.setEnter(eventDate);
            }
        }
        return nodeInstance;
    }

    private void indexState(ProcessInstanceEntity pi, ProcessInstanceStateDataEvent event) {
        this.indexState(pi, (ProcessInstanceStateEventBody)event.getData(), event.getKogitoAddons() == null || event.getKogitoAddons().isEmpty() ? Set.of() : Set.of(event.getKogitoAddons().split(",")), event.getSource() == null ? null : event.getSource().toString());
    }

    private void indexState(ProcessInstanceEntity pi, ProcessInstanceStateEventBody data, Set<String> addons, String endpoint) {
        pi.setVersion(data.getProcessVersion());
        pi.setProcessName(data.getProcessName());
        pi.setRootProcessInstanceId(data.getRootProcessInstanceId());
        pi.setRootProcessId(data.getRootProcessId());
        pi.setParentProcessInstanceId(data.getParentInstanceId());
        pi.setRoles(data.getRoles());
        pi.setState(data.getState());
        if (data.getEventType() == null || data.getEventType() == 1) {
            pi.setStart(DateTimeUtils.toZonedDateTime((Date)data.getEventDate()));
            pi.setCreatedBy(data.getEventUser());
        } else if (data.getEventType() == 2) {
            pi.setEnd(DateTimeUtils.toZonedDateTime((Date)data.getEventDate()));
        } else if (data.getEventType() == 4) {
            pi.setError(null);
        }
        pi.setBusinessKey(data.getBusinessKey());
        pi.setUpdatedBy(data.getEventUser());
        pi.setLastUpdate(DateTimeUtils.toZonedDateTime((Date)data.getEventDate()));
        pi.setAddons(addons);
        pi.setEndpoint(endpoint);
        pi.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)data.getSlaDueDate()));
    }

    private void indexVariable(ProcessInstanceEntity pi, ProcessInstanceVariableEventBody data) {
        pi.setVariables(JsonUtils.mergeVariable((String)data.getVariableName(), (Object)data.getVariableValue(), (ObjectNode)pi.getVariables()));
    }

    private void indexSla(ProcessInstanceEntity orInit, ProcessInstanceSLAEventBody data) {
    }

    public Set<StorageServiceCapability> capabilities() {
        return EnumSet.of(StorageServiceCapability.COUNT);
    }
}

