/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.jpa.storage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.UrlEscapers;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.kie.kogito.event.usertask.MultipleUserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableEventBody;
import org.kie.kogito.index.CommonUtils;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.jpa.mapper.UserTaskInstanceEntityMapper;
import org.kie.kogito.index.jpa.model.AttachmentEntity;
import org.kie.kogito.index.jpa.model.CommentEntity;
import org.kie.kogito.index.jpa.model.UserTaskInstanceEntity;
import org.kie.kogito.index.jpa.model.UserTaskInstanceEntityRepository;
import org.kie.kogito.index.jpa.storage.AbstractJPAStorageFetcher;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.storage.UserTaskInstanceStorage;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

@ApplicationScoped
public class UserTaskInstanceEntityStorage
extends AbstractJPAStorageFetcher<String, UserTaskInstanceEntity, UserTaskInstance>
implements UserTaskInstanceStorage {
    protected UserTaskInstanceEntityStorage() {
    }

    @Inject
    public UserTaskInstanceEntityStorage(UserTaskInstanceEntityRepository repository, UserTaskInstanceEntityMapper mapper) {
        super(repository, UserTaskInstanceEntity.class, mapper::mapToModel);
    }

    @Transactional
    public void indexGroup(MultipleUserTaskInstanceDataEvent events) {
        HashMap<String, UserTaskInstanceEntity> taskMap = new HashMap<String, UserTaskInstanceEntity>();
        for (UserTaskInstanceDataEvent event : (Collection)events.getData()) {
            this.indexEvent(taskMap.computeIfAbsent(event.getKogitoUserTaskInstanceId(), id -> this.findOrInit((String)id)), event);
        }
    }

    @Transactional
    public void indexAssignment(UserTaskInstanceAssignmentDataEvent event) {
        this.indexAssignment(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexAttachment(UserTaskInstanceAttachmentDataEvent event) {
        this.indexAttachment(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexDeadline(UserTaskInstanceDeadlineDataEvent event) {
        this.indexDeadline(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexState(UserTaskInstanceStateDataEvent event) {
        this.indexState(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexComment(UserTaskInstanceCommentDataEvent event) {
        this.indexComment(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    @Transactional
    public void indexVariable(UserTaskInstanceVariableDataEvent event) {
        this.indexVariable(this.findOrInit((UserTaskInstanceDataEvent<?>)event), event);
    }

    private void indexEvent(UserTaskInstanceEntity task, UserTaskInstanceDataEvent<?> event) {
        if (event instanceof UserTaskInstanceAssignmentDataEvent) {
            this.indexAssignment(task, (UserTaskInstanceAssignmentDataEvent)event);
        } else if (event instanceof UserTaskInstanceAttachmentDataEvent) {
            this.indexAttachment(task, (UserTaskInstanceAttachmentDataEvent)event);
        } else if (event instanceof UserTaskInstanceDeadlineDataEvent) {
            this.indexDeadline(task, (UserTaskInstanceDeadlineDataEvent)event);
        } else if (event instanceof UserTaskInstanceStateDataEvent) {
            this.indexState(task, (UserTaskInstanceStateDataEvent)event);
        } else if (event instanceof UserTaskInstanceCommentDataEvent) {
            this.indexComment(task, (UserTaskInstanceCommentDataEvent)event);
        } else if (event instanceof UserTaskInstanceVariableDataEvent) {
            this.indexVariable(task, (UserTaskInstanceVariableDataEvent)event);
        }
    }

    private void indexAssignment(UserTaskInstanceEntity userTaskInstance, UserTaskInstanceAssignmentDataEvent event) {
        UserTaskInstanceAssignmentEventBody body = (UserTaskInstanceAssignmentEventBody)event.getData();
        switch (body.getAssignmentType()) {
            case "USER_OWNERS": {
                userTaskInstance.setPotentialUsers(new HashSet<String>(body.getUsers()));
                break;
            }
            case "USER_GROUPS": {
                userTaskInstance.setPotentialGroups(new HashSet<String>(body.getUsers()));
                break;
            }
            case "USERS_EXCLUDED": {
                userTaskInstance.setExcludedUsers(new HashSet<String>(body.getUsers()));
                break;
            }
            case "ADMIN_GROUPS": {
                userTaskInstance.setAdminGroups(new HashSet<String>(body.getUsers()));
                break;
            }
            case "ADMIN_USERS": {
                userTaskInstance.setAdminUsers(new HashSet<String>(body.getUsers()));
            }
        }
    }

    private void indexAttachment(UserTaskInstanceEntity userTaskInstance, UserTaskInstanceAttachmentDataEvent event) {
        UserTaskInstanceAttachmentEventBody body = (UserTaskInstanceAttachmentEventBody)event.getData();
        List<AttachmentEntity> attachments = userTaskInstance.getAttachments();
        switch (body.getEventType()) {
            case 1: 
            case 2: {
                AttachmentEntity attachment = attachments.stream().filter(e -> e.getId().equals(body.getAttachmentId())).findAny().orElseGet(() -> {
                    AttachmentEntity newAttachment = new AttachmentEntity();
                    newAttachment.setUserTask(userTaskInstance);
                    attachments.add(newAttachment);
                    return newAttachment;
                });
                attachment.setId(body.getAttachmentId());
                attachment.setName(body.getAttachmentName());
                attachment.setContent(body.getAttachmentURI().toString());
                attachment.setUpdatedBy(body.getEventUser() != null ? body.getEventUser() : "unknown");
                attachment.setUpdatedAt(DateTimeUtils.toZonedDateTime((Date)body.getEventDate()));
                break;
            }
            case 3: {
                attachments.removeIf(e -> e.getId().equals(body.getAttachmentId()));
            }
        }
    }

    private void indexDeadline(UserTaskInstanceEntity userTaskInstance, UserTaskInstanceDeadlineDataEvent event) {
    }

    private void indexState(UserTaskInstanceEntity task, UserTaskInstanceStateDataEvent event) {
        UserTaskInstanceStateEventBody body = (UserTaskInstanceStateEventBody)event.getData();
        task.setProcessInstanceId(body.getProcessInstanceId());
        task.setProcessId(event.getKogitoProcessId());
        task.setRootProcessId(event.getKogitoRootProcessId());
        task.setRootProcessInstanceId(event.getKogitoRootProcessInstanceId());
        task.setName(body.getUserTaskName());
        task.setDescription(body.getUserTaskDescription());
        task.setState(body.getState());
        task.setPriority(body.getUserTaskPriority());
        if (task.getStarted() == null) {
            task.setStarted(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        } else if (CommonUtils.isTaskCompleted((String)((UserTaskInstanceStateEventBody)event.getData()).getEventType())) {
            task.setCompleted(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        }
        task.setActualOwner(((UserTaskInstanceStateEventBody)event.getData()).getActualOwner());
        task.setEndpoint(event.getSource() == null ? null : this.getEndpoint(event.getSource(), ((UserTaskInstanceStateEventBody)event.getData()).getProcessInstanceId(), ((UserTaskInstanceStateEventBody)event.getData()).getUserTaskName(), ((UserTaskInstanceStateEventBody)event.getData()).getExternalReferenceId()));
        task.setLastUpdate(DateTimeUtils.toZonedDateTime((Date)((UserTaskInstanceStateEventBody)event.getData()).getEventDate()));
        task.setReferenceName(((UserTaskInstanceStateEventBody)event.getData()).getUserTaskReferenceName());
        task.setExternalReferenceId(body.getExternalReferenceId());
        task.setSlaDueDate(DateTimeUtils.toZonedDateTime((Date)body.getSlaDueDate()));
    }

    private String getEndpoint(URI source, String pId, String taskName, String taskId) {
        String name = UrlEscapers.urlPathSegmentEscaper().escape(taskName);
        return source.toString() + String.format("/%s/%s/%s", pId, name, taskId);
    }

    private void indexComment(UserTaskInstanceEntity userTaskInstance, UserTaskInstanceCommentDataEvent event) {
        UserTaskInstanceCommentEventBody body = (UserTaskInstanceCommentEventBody)event.getData();
        List<CommentEntity> comments = userTaskInstance.getComments();
        switch (body.getEventType()) {
            case 1: 
            case 2: {
                CommentEntity comment = comments.stream().filter(e -> e.getId().equals(body.getCommentId())).findAny().orElseGet(() -> {
                    CommentEntity newComment = new CommentEntity();
                    newComment.setUserTask(userTaskInstance);
                    comments.add(newComment);
                    return newComment;
                });
                comment.setId(body.getCommentId());
                comment.setContent(body.getCommentContent());
                comment.setUpdatedBy(body.getEventUser() != null ? body.getEventUser() : "unknown");
                comment.setUpdatedAt(DateTimeUtils.toZonedDateTime((Date)body.getEventDate()));
                break;
            }
            case 3: {
                comments.removeIf(e -> e.getId().equals(body.getCommentId()));
            }
        }
    }

    private void indexVariable(UserTaskInstanceEntity userTaskInstance, UserTaskInstanceVariableDataEvent event) {
        UserTaskInstanceVariableEventBody body = (UserTaskInstanceVariableEventBody)event.getData();
        if (body.getVariableType().equals("INPUT")) {
            ObjectNode objectNode = userTaskInstance.getInputs();
            if (objectNode == null) {
                objectNode = ObjectMapperFactory.get().createObjectNode();
            }
            objectNode.set(body.getVariableName(), JsonObjectUtils.fromValue((Object)body.getVariableValue()));
            userTaskInstance.setInputs(objectNode);
        } else {
            ObjectNode objectNode = userTaskInstance.getOutputs();
            if (objectNode == null) {
                objectNode = ObjectMapperFactory.get().createObjectNode();
            }
            objectNode.set(body.getVariableName(), JsonObjectUtils.fromValue((Object)body.getVariableValue()));
            userTaskInstance.setOutputs(objectNode);
        }
    }

    private UserTaskInstanceEntity findOrInit(UserTaskInstanceDataEvent<?> event) {
        return this.findOrInit(event.getKogitoUserTaskInstanceId());
    }

    private UserTaskInstanceEntity findOrInit(String taskId) {
        return this.repository.findByIdOptional((Object)taskId).orElseGet(() -> {
            UserTaskInstanceEntity ut = new UserTaskInstanceEntity();
            ut.setId(taskId);
            this.repository.persist((Object)ut);
            return ut;
        });
    }
}

