/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import java.time.ZonedDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.mongodb.model.JobEntity;
import org.kie.kogito.index.mongodb.model.JobEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class JobEntityMapperTest {
    JobEntityMapper jobEntityMapper = new JobEntityMapper();
    static Job job;
    static JobEntity jobEntity;

    JobEntityMapperTest() {
    }

    @BeforeAll
    static void setup() {
        String testId = "testId";
        ZonedDateTime time = ZonedDateTime.now();
        String status = "ACTIVE";
        String processId = "testProcessId";
        String processInstanceId = "testProcessInstanceId";
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        Integer priority = 79;
        String callbackEndpoint = "testCallbackEndpoint";
        Long repeatInterval = 70L;
        Integer repeatLimit = 89;
        String scheduledId = "testScheduleId";
        Integer retries = 25;
        Integer executionCounter = 17;
        job = new Job();
        job.setId(testId);
        job.setStatus(status);
        job.setLastUpdate(time);
        job.setProcessId(processId);
        job.setProcessInstanceId(processInstanceId);
        job.setRootProcessId(rootProcessId);
        job.setRootProcessInstanceId(rootProcessInstanceId);
        job.setExpirationTime(time);
        job.setPriority(priority);
        job.setCallbackEndpoint(callbackEndpoint);
        job.setRepeatInterval(repeatInterval);
        job.setRepeatLimit(repeatLimit);
        job.setScheduledId(scheduledId);
        job.setRetries(retries);
        job.setExecutionCounter(executionCounter);
        jobEntity = new JobEntity();
        jobEntity.setId(testId);
        jobEntity.setStatus(status);
        jobEntity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        jobEntity.setProcessId(processId);
        jobEntity.setProcessInstanceId(processInstanceId);
        jobEntity.setRootProcessId(rootProcessId);
        jobEntity.setRootProcessInstanceId(rootProcessInstanceId);
        jobEntity.setExpirationTime(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        jobEntity.setPriority(priority);
        jobEntity.setCallbackEndpoint(callbackEndpoint);
        jobEntity.setRepeatInterval(repeatInterval);
        jobEntity.setRepeatLimit(repeatLimit);
        jobEntity.setScheduledId(scheduledId);
        jobEntity.setRetries(retries);
        jobEntity.setExecutionCounter(executionCounter);
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(JobEntity.class, (Object)this.jobEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        JobEntity result = this.jobEntityMapper.mapToEntity(job.getId(), job);
        Assertions.assertEquals((Object)jobEntity, (Object)result);
    }

    @Test
    void testMapToModel() {
        Job result = this.jobEntityMapper.mapToModel(jobEntity);
        Assertions.assertEquals((Object)job, (Object)result);
    }
}

