/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.UUID;
import javax.inject.Inject;
import org.bson.Document;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.TestUtils;
import org.kie.kogito.index.mongodb.model.DomainEntityMapper;
import org.kie.kogito.index.mongodb.storage.StorageTestBase;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class DomainStorageIT
extends StorageTestBase<String, ObjectNode> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, ObjectNode> storage;

    DomainStorageIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("travels_domain", Document.class), this.mongoClientManager.getReactiveCollection("travels_domain", Document.class), "org.acme.travels.travels.Travels", (MongoEntityMapper)new DomainEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void testCache() {
        String processInstanceId = UUID.randomUUID().toString();
        ObjectNode node1 = TestUtils.createDomainData(processInstanceId, "John", "Doe");
        ObjectNode node2 = TestUtils.createDomainData(processInstanceId, "Jane", "Toe");
        this.testStorage(this.storage, processInstanceId, node1, node2);
    }
}

