/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.query;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.model.ProcessIdEntity;
import org.kie.kogito.index.mongodb.model.ProcessIdEntityMapper;
import org.kie.kogito.index.mongodb.query.QueryTestBase;
import org.kie.kogito.index.mongodb.query.QueryTestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class ProcessIdQueryIT
extends QueryTestBase<String, String> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, String> storage;

    ProcessIdQueryIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("processidmodel", ProcessIdEntity.class), this.mongoClientManager.getReactiveCollection("processidmodel", ProcessIdEntity.class), String.class.getName(), (MongoEntityMapper)new ProcessIdEntityMapper());
        this.storage.clear();
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void test() {
        String processId = "travels";
        String subProcessId = "travels_sub";
        String type1 = "org.acme.travels.travels";
        String type2 = "org.acme.travels";
        this.storage.put((Object)processId, (Object)type1);
        this.storage.put((Object)subProcessId, (Object)type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.in((String)"processId", Arrays.asList(processId, subProcessId))), null, null, null, type1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"processId", (Object)processId)), null, null, null, type1);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.notNull((String)"processId")), null, null, null, type1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.contains((String)"fullTypeName", (String)type1)), null, null, null, type1);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.containsAny((String)"fullTypeName", Arrays.asList(type1, type2))), null, null, null, type1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.containsAll((String)"processId", Arrays.asList(processId, subProcessId))), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.like((String)"processId", (String)"*_sub")), null, null, null, type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.equalTo((String)"processId", (Object)processId), QueryFilterFactory.equalTo((String)"fullTypeName", (Object)type1)))), null, null, null, type1);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Collections.singletonList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.equalTo((String)"processId", (Object)processId), QueryFilterFactory.equalTo((String)"fullTypeName", (Object)type2)))), null, null, null, type1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithString(), this.storage, Arrays.asList(QueryFilterFactory.equalTo((String)"processId", (Object)processId), QueryFilterFactory.equalTo((String)"fullTypeName", (Object)type2)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithStringInOrder(), this.storage, Collections.singletonList(QueryFilterFactory.in((String)"processId", Arrays.asList(processId, subProcessId))), Collections.singletonList(QueryFilterFactory.orderBy((String)"fullTypeName", (SortDirection)SortDirection.DESC)), 1, 1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithStringInOrder(), this.storage, null, Collections.singletonList(QueryFilterFactory.orderBy((String)"fullTypeName", (SortDirection)SortDirection.DESC)), 1, 1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithStringInOrder(), this.storage, null, Arrays.asList(QueryFilterFactory.orderBy((String)"fullTypeName", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"processId", (SortDirection)SortDirection.DESC)), null, null, type1, type2);
        this.queryAndAssert(QueryTestUtils.assertWithStringInOrder(), this.storage, null, null, 1, 1, type2);
    }
}

