/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class UserTaskInstanceEntityMapperTest {
    UserTaskInstanceEntityMapper userTaskInstanceEntityMapper = new UserTaskInstanceEntityMapper();
    static UserTaskInstance userTaskInstance;
    static UserTaskInstanceEntity userTaskInstanceEntity;

    UserTaskInstanceEntityMapperTest() {
    }

    @BeforeAll
    static void setup() {
        String testId = "testId";
        String description = "testDescription";
        String name = "testName";
        String priority = "10";
        String processInstanceId = "testProcessInstanceId";
        String state = "testState";
        String actualOwner = "testActualOwner";
        Set<String> adminGroups = Set.of("testAdminGroups");
        Set<String> adminUsers = Set.of("testAdminUsers");
        ZonedDateTime time = ZonedDateTime.now();
        Set<String> excludedUsers = Set.of("testExcludedUsers");
        Set<String> potentialGroups = Set.of("testPotentialGroups");
        Set<String> potentialUsers = Set.of("testPotentialUsers");
        String referenceName = "testReferenceName";
        String processId = "testProcessId";
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("test", "testValue");
        JsonNode inputs = ModelUtils.MAPPER.valueToTree(object);
        JsonNode outputs = ModelUtils.MAPPER.valueToTree(object);
        userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(testId);
        userTaskInstance.setDescription(description);
        userTaskInstance.setName(name);
        userTaskInstance.setPriority(priority);
        userTaskInstance.setProcessInstanceId(processInstanceId);
        userTaskInstance.setState(state);
        userTaskInstance.setActualOwner(actualOwner);
        userTaskInstance.setAdminGroups(adminGroups);
        userTaskInstance.setAdminUsers(adminUsers);
        userTaskInstance.setCompleted(time);
        userTaskInstance.setStarted(time);
        userTaskInstance.setExcludedUsers(excludedUsers);
        userTaskInstance.setPotentialGroups(potentialGroups);
        userTaskInstance.setPotentialUsers(potentialUsers);
        userTaskInstance.setReferenceName(referenceName);
        userTaskInstance.setLastUpdate(time);
        userTaskInstance.setProcessId(processId);
        userTaskInstance.setRootProcessId(rootProcessId);
        userTaskInstance.setRootProcessInstanceId(rootProcessInstanceId);
        userTaskInstance.setInputs(inputs);
        userTaskInstance.setOutputs(outputs);
        userTaskInstanceEntity = new UserTaskInstanceEntity();
        userTaskInstanceEntity.setId(testId);
        userTaskInstanceEntity.setDescription(description);
        userTaskInstanceEntity.setName(name);
        userTaskInstanceEntity.setPriority(priority);
        userTaskInstanceEntity.setProcessInstanceId(processInstanceId);
        userTaskInstanceEntity.setState(state);
        userTaskInstanceEntity.setActualOwner(actualOwner);
        userTaskInstanceEntity.setAdminGroups(adminGroups);
        userTaskInstanceEntity.setAdminUsers(adminUsers);
        userTaskInstanceEntity.setCompleted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setStarted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setExcludedUsers(excludedUsers);
        userTaskInstanceEntity.setPotentialGroups(potentialGroups);
        userTaskInstanceEntity.setPotentialUsers(potentialUsers);
        userTaskInstanceEntity.setReferenceName(referenceName);
        userTaskInstanceEntity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setProcessId(processId);
        userTaskInstanceEntity.setRootProcessId(rootProcessId);
        userTaskInstanceEntity.setRootProcessInstanceId(rootProcessInstanceId);
        userTaskInstanceEntity.setInputs(ModelUtils.jsonNodeToDocument((JsonNode)inputs));
        userTaskInstanceEntity.setOutputs(ModelUtils.jsonNodeToDocument((JsonNode)outputs));
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(UserTaskInstanceEntity.class, (Object)this.userTaskInstanceEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        UserTaskInstanceEntity result = this.userTaskInstanceEntityMapper.mapToEntity(userTaskInstance.getId(), userTaskInstance);
        Assertions.assertEquals((Object)userTaskInstanceEntity, (Object)result);
    }

    @Test
    void testMapToModel() {
        UserTaskInstance result = this.userTaskInstanceEntityMapper.mapToModel(userTaskInstanceEntity);
        Assertions.assertEquals((Object)userTaskInstance, (Object)result);
    }
}

