/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.query;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.mongodb.TestUtils;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntity;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntityMapper;
import org.kie.kogito.index.mongodb.query.QueryTestBase;
import org.kie.kogito.index.mongodb.query.QueryTestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class ProcessInstanceQueryIT
extends QueryTestBase<String, ProcessInstance> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, ProcessInstance> storage;

    ProcessInstanceQueryIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("processinstances", ProcessInstanceEntity.class), this.mongoClientManager.getReactiveCollection("processinstances", ProcessInstanceEntity.class), ProcessInstance.class.getName(), (MongoEntityMapper)new ProcessInstanceEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void test() {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        String subProcessId = processId + "_sub";
        String subProcessInstanceId = UUID.randomUUID().toString();
        ProcessInstance processInstance = TestUtils.createProcessInstance(processInstanceId, processId, null, null, ProcessInstanceState.ACTIVE.ordinal(), 0L);
        ProcessInstance subProcessInstance = TestUtils.createProcessInstance(subProcessInstanceId, subProcessId, processInstanceId, processId, ProcessInstanceState.COMPLETED.ordinal(), 1000L);
        this.storage.put((Object)processInstanceId, (Object)processInstance);
        this.storage.put((Object)subProcessInstanceId, (Object)subProcessInstance);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.in((String)"state", Arrays.asList(ProcessInstanceState.ACTIVE.ordinal(), ProcessInstanceState.COMPLETED.ordinal()))), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal())), null, null, null, processInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThan((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal())), null, null, null, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThanEqual((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal())), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThan((String)"state", (Object)ProcessInstanceState.COMPLETED.ordinal())), null, null, null, processInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThanEqual((String)"state", (Object)ProcessInstanceState.COMPLETED.ordinal())), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.between((String)"state", (Object)ProcessInstanceState.ACTIVE.ordinal(), (Object)ProcessInstanceState.COMPLETED.ordinal())), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.isNull((String)"rootProcessInstanceId")), null, null, null, processInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.notNull((String)"rootProcessInstanceId")), null, null, null, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.contains((String)"roles", (String)"admin")), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAny((String)"roles", Arrays.asList("admin", "kogito"))), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAll((String)"roles", Arrays.asList("admin", "kogito"))), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.like((String)"processId", (String)"*_sub")), null, null, null, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.lessThan((String)"start", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()), QueryFilterFactory.lessThanEqual((String)"start", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli())))), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.equalTo((String)"rootProcessInstanceId", (Object)processInstanceId), QueryFilterFactory.equalTo((String)"start", (Object)processInstance.getStart().toInstant().toEpochMilli())))), null, null, null, processInstanceId, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Arrays.asList(QueryFilterFactory.isNull((String)"roles"), QueryFilterFactory.isNull((String)"end"), QueryFilterFactory.greaterThan((String)"start", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()), QueryFilterFactory.greaterThanEqual((String)"start", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"nodes.id", (Object)((NodeInstance)processInstance.getNodes().get(0)).getId())), null, null, null, processInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, Arrays.asList(QueryFilterFactory.in((String)"id", Arrays.asList(processInstanceId, subProcessInstanceId)), QueryFilterFactory.in((String)"processId", Arrays.asList(processId, subProcessId))), Collections.singletonList(QueryFilterFactory.orderBy((String)"processId", (SortDirection)SortDirection.ASC)), 1, 1, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Collections.singletonList(QueryFilterFactory.orderBy((String)"processId", (SortDirection)SortDirection.DESC)), null, null, subProcessInstanceId, processInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, null, 1, 1, subProcessInstanceId);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Arrays.asList(QueryFilterFactory.orderBy((String)"processId", (SortDirection)SortDirection.ASC), QueryFilterFactory.orderBy((String)"state", (SortDirection)SortDirection.ASC)), 1, 1, subProcessInstanceId);
    }
}

