/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.query;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.TestUtils;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.index.mongodb.query.QueryTestBase;
import org.kie.kogito.index.mongodb.query.QueryTestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class UserTaskInstanceQueryIT
extends QueryTestBase<String, UserTaskInstance> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, UserTaskInstance> storage;

    UserTaskInstanceQueryIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("usertaskinstances", UserTaskInstanceEntity.class), this.mongoClientManager.getReactiveCollection("usertaskinstances", UserTaskInstanceEntity.class), UserTaskInstance.class.getName(), (MongoEntityMapper)new UserTaskInstanceEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void test() {
        String taskId1 = UUID.randomUUID().toString();
        String processInstanceId1 = UUID.randomUUID().toString();
        String taskId2 = UUID.randomUUID().toString();
        String processInstanceId2 = UUID.randomUUID().toString();
        UserTaskInstance userTaskInstance1 = TestUtils.createUserTaskInstance(taskId1, processInstanceId1, RandomStringUtils.randomAlphabetic((int)5), UUID.randomUUID().toString(), RandomStringUtils.randomAlphabetic((int)10), "InProgress", 0L);
        UserTaskInstance userTaskInstance2 = TestUtils.createUserTaskInstance(taskId2, processInstanceId2, RandomStringUtils.randomAlphabetic((int)5), null, null, "Completed", 1000L);
        this.storage.put((Object)taskId1, (Object)userTaskInstance1);
        this.storage.put((Object)taskId2, (Object)userTaskInstance2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.in((String)"state", Arrays.asList("InProgress", "Completed"))), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"state", (Object)"InProgress")), null, null, null, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThan((String)"started", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThanEqual((String)"completed", (Object)Instant.now().minus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThan((String)"completed", (Object)Instant.now().minus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThanEqual((String)"started", (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.between((String)"completed", (Object)Instant.now().minus(1L, ChronoUnit.DAYS).toEpochMilli(), (Object)Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli())), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.isNull((String)"rootProcessInstanceId")), null, null, null, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.notNull((String)"rootProcessInstanceId")), null, null, null, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.contains((String)"id", (String)taskId1)), null, null, null, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAny((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAll((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.like((String)"state", (String)"*ss")), null, null, null, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)taskId1), QueryFilterFactory.equalTo((String)"processInstanceId", (Object)processInstanceId1)))), null, null, null, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)taskId1), QueryFilterFactory.equalTo((String)"id", (Object)taskId2)))), null, null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)taskId1), QueryFilterFactory.equalTo((String)"processInstanceId", (Object)processInstanceId2)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, Arrays.asList(QueryFilterFactory.in((String)"id", Arrays.asList(taskId1, taskId2)), QueryFilterFactory.in((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), Collections.singletonList(QueryFilterFactory.orderBy((String)"state", (SortDirection)SortDirection.ASC)), 1, 1, taskId1);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Collections.singletonList(QueryFilterFactory.orderBy((String)"state", (SortDirection)SortDirection.DESC)), null, null, taskId1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, null, 1, 1, taskId2);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Arrays.asList(QueryFilterFactory.orderBy((String)"state", (SortDirection)SortDirection.ASC), QueryFilterFactory.orderBy((String)"completed", (SortDirection)SortDirection.ASC)), 1, 1, taskId1);
    }
}

