/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.model.DomainEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class DomainEntityMapperTest {
    DomainEntityMapper domainEntityMapper = new DomainEntityMapper();

    DomainEntityMapperTest() {
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(Document.class, (Object)this.domainEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        String testId = "testId";
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("id", testId);
        objectMap.put("testKey", "testValue");
        ObjectNode object = (ObjectNode)ModelUtils.MAPPER.valueToTree(objectMap);
        Document document = new Document("_id", (Object)testId).append("testKey", (Object)"testValue");
        Document result = this.domainEntityMapper.mapToEntity(testId, object);
        Assertions.assertEquals((Object)document, (Object)result);
    }

    @Test
    void testMapToModel() {
        String testId = "testId";
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("id", testId);
        objectMap.put("testKey", "testValue");
        ObjectNode object = (ObjectNode)ModelUtils.MAPPER.valueToTree(objectMap);
        Document document = new Document("_id", (Object)testId).append("testKey", (Object)"testValue");
        ObjectNode result = this.domainEntityMapper.mapToModel(document);
        Assertions.assertEquals((Object)object, (Object)result);
    }
}

