/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.query;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.mongodb.TestUtils;
import org.kie.kogito.index.mongodb.model.JobEntity;
import org.kie.kogito.index.mongodb.model.JobEntityMapper;
import org.kie.kogito.index.mongodb.query.QueryTestBase;
import org.kie.kogito.index.mongodb.query.QueryTestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class JobQueryIT
extends QueryTestBase<String, Job> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, Job> storage;

    JobQueryIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("jobs", JobEntity.class), this.mongoClientManager.getReactiveCollection("jobs", JobEntity.class), Job.class.getName(), (MongoEntityMapper)new JobEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void test() {
        String jobId1 = UUID.randomUUID().toString();
        String processInstanceId1 = UUID.randomUUID().toString();
        String jobId2 = UUID.randomUUID().toString();
        String processInstanceId2 = UUID.randomUUID().toString();
        Job job1 = TestUtils.createJob(jobId1, processInstanceId1, RandomStringUtils.randomAlphabetic((int)5), UUID.randomUUID().toString(), RandomStringUtils.randomAlphabetic((int)10), "EXPECTED", 0L);
        Job job2 = TestUtils.createJob(jobId2, processInstanceId2, RandomStringUtils.randomAlphabetic((int)5), null, null, "SCHEDULED", 1000L);
        this.storage.put((Object)jobId1, (Object)job1);
        this.storage.put((Object)jobId2, (Object)job2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.in((String)"status", Arrays.asList("EXPECTED", "SCHEDULED"))), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"status", (Object)"EXPECTED")), null, null, null, jobId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThan((String)"priority", (Object)1)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.greaterThanEqual((String)"priority", (Object)1)), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThan((String)"priority", (Object)1)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1)), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.between((String)"priority", (Object)0, (Object)3)), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.isNull((String)"rootProcessInstanceId")), null, null, null, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.notNull((String)"rootProcessInstanceId")), null, null, null, jobId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.contains((String)"id", (String)jobId1)), null, null, null, jobId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAny((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.containsAll((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.like((String)"status", (String)"EX*")), null, null, null, jobId1);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.lessThan((String)"retries", (Object)11), QueryFilterFactory.greaterThanEqual((String)"retries", (Object)10)))), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Collections.singletonList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)jobId1), QueryFilterFactory.equalTo((String)"id", (Object)jobId2)))), null, null, null, jobId1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithId(), this.storage, Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)jobId1), QueryFilterFactory.equalTo((String)"processInstanceId", (Object)processInstanceId2)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, Arrays.asList(QueryFilterFactory.in((String)"id", Arrays.asList(jobId1, jobId2)), QueryFilterFactory.in((String)"processInstanceId", Arrays.asList(processInstanceId1, processInstanceId2))), Collections.singletonList(QueryFilterFactory.orderBy((String)"status", (SortDirection)SortDirection.ASC)), 1, 1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Collections.singletonList(QueryFilterFactory.orderBy((String)"status", (SortDirection)SortDirection.DESC)), null, null, jobId2, jobId1);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, null, 1, 1, jobId2);
        this.queryAndAssert(QueryTestUtils.assertWithIdInOrder(), this.storage, null, Arrays.asList(QueryFilterFactory.orderBy((String)"status", (SortDirection)SortDirection.ASC), QueryFilterFactory.orderBy((String)"priority", (SortDirection)SortDirection.ASC)), 1, 1, jobId2);
    }
}

