/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.mock.MockIndexCreateOrUpdateEventListener;
import org.kie.kogito.index.mongodb.model.DomainEntityMapper;
import org.kie.kogito.index.mongodb.model.JobEntityMapper;
import org.kie.kogito.index.mongodb.model.ProcessIdEntityMapper;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntityMapper;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.index.mongodb.storage.MongoModelServiceImpl;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class MongoModelServiceImplIT {
    @Inject
    MockIndexCreateOrUpdateEventListener mockIndexCreateOrUpdateEventListener;
    @Inject
    MongoModelServiceImpl mongoModelServiceImpl;

    MongoModelServiceImplIT() {
    }

    @BeforeEach
    void setup() {
        Assertions.assertNotNull((Object)this.mongoModelServiceImpl.getEntityMapper("processinstances"));
        this.mockIndexCreateOrUpdateEventListener.reset();
    }

    @AfterEach
    void tearDown() {
        this.mockIndexCreateOrUpdateEventListener.reset();
    }

    @Test
    void testInit() {
        this.mongoModelServiceImpl.init();
        this.mockIndexCreateOrUpdateEventListener.assertFire("processinstances", ProcessInstance.class.getName());
        this.mockIndexCreateOrUpdateEventListener.assertFire("usertaskinstances", UserTaskInstance.class.getName());
        this.mockIndexCreateOrUpdateEventListener.assertFire("jobs", Job.class.getName());
    }

    @Test
    void testGetEntityMapper() {
        Assertions.assertTrue((boolean)(this.mongoModelServiceImpl.getEntityMapper("jobs") instanceof JobEntityMapper));
        Assertions.assertTrue((boolean)(this.mongoModelServiceImpl.getEntityMapper("processinstances") instanceof ProcessInstanceEntityMapper));
        Assertions.assertTrue((boolean)(this.mongoModelServiceImpl.getEntityMapper("usertaskinstances") instanceof UserTaskInstanceEntityMapper));
        Assertions.assertTrue((boolean)(this.mongoModelServiceImpl.getEntityMapper("processidmodel") instanceof ProcessIdEntityMapper));
        Assertions.assertTrue((boolean)(this.mongoModelServiceImpl.getEntityMapper("test_domain") instanceof DomainEntityMapper));
    }
}

