/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.mock.MockIndexCreateOrUpdateEventListener;
import org.kie.kogito.index.mongodb.model.ProcessIdEntity;
import org.kie.kogito.index.mongodb.model.ProcessIdEntityMapper;
import org.kie.kogito.index.mongodb.storage.ProcessIndexObserver;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.index.ProcessIndexEvent;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class ProcessIndexObserverIT {
    @Inject
    MongoClientManager mongoClientManager;
    @Inject
    MockIndexCreateOrUpdateEventListener mockIndexCreateOrUpdateEventListener;
    @Inject
    ProcessIndexObserver processIndexObserver;

    ProcessIndexObserverIT() {
    }

    @BeforeEach
    void setup() {
        this.mockIndexCreateOrUpdateEventListener.reset();
    }

    @AfterEach
    void tearDown() {
        this.mockIndexCreateOrUpdateEventListener.reset();
    }

    @Test
    void testOnProcessIndexEvent() {
        String processId = "testProcess";
        String processType = "testProcessType";
        ProcessDescriptor processDescriptor = new ProcessDescriptor(processId, processType);
        ProcessIndexEvent processIndexEvent = new ProcessIndexEvent(processDescriptor);
        this.processIndexObserver.onProcessIndexEvent(processIndexEvent);
        MongoStorage processIdStorage = new MongoStorage(this.mongoClientManager.getCollection("processidmodel", ProcessIdEntity.class), this.mongoClientManager.getReactiveCollection("processidmodel", ProcessIdEntity.class), String.class.getName(), (MongoEntityMapper)new ProcessIdEntityMapper());
        Assertions.assertTrue((boolean)processIdStorage.containsKey((Object)processId));
        Assertions.assertEquals((Object)processType, (Object)processIdStorage.get((Object)processId));
        this.mockIndexCreateOrUpdateEventListener.assertFire("testProcess_domain", processType);
    }
}

