/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.bson.Document;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;

public class DomainEntityMapper
implements MongoEntityMapper<ObjectNode, Document> {
    static final String ID = "id";

    public Class<Document> getEntityClass() {
        return Document.class;
    }

    public Document mapToEntity(String key, ObjectNode value) {
        if (value == null) {
            return null;
        }
        ObjectNode n = value.deepCopy();
        n.remove(ID);
        return ModelUtils.jsonNodeToDocument((JsonNode)n).append("_id", (Object)key);
    }

    public ObjectNode mapToModel(Document entity) {
        if (entity == null) {
            return null;
        }
        Object idObj = entity.remove((Object)"_id");
        if (idObj != null) {
            ObjectNode result = ModelUtils.MAPPER.createObjectNode();
            result.put(ID, idObj.toString());
            result.setAll(ModelUtils.documentToJsonNode((Document)entity));
            return result;
        }
        return ModelUtils.documentToJsonNode((Document)entity);
    }
}

