/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.Constants;
import org.kie.kogito.index.mongodb.model.DomainEntityMapper;
import org.kie.kogito.index.mongodb.model.JobEntityMapper;
import org.kie.kogito.index.mongodb.model.ProcessIdEntityMapper;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntityMapper;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.persistence.mongodb.index.IndexCreateOrUpdateEvent;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoModelService;

@ApplicationScoped
public class MongoModelServiceImpl
implements MongoModelService {
    @Inject
    Event<IndexCreateOrUpdateEvent> indexCreateOrUpdateEvent;
    static final Map<String, Supplier<MongoEntityMapper<?, ?>>> ENTITY_MAPPER_MAP = Map.of("jobs", JobEntityMapper::new, "processinstances", ProcessInstanceEntityMapper::new, "usertaskinstances", UserTaskInstanceEntityMapper::new, "processidmodel", ProcessIdEntityMapper::new);

    @PostConstruct
    void init() {
        this.indexCreateOrUpdateEvent.fire((Object)new IndexCreateOrUpdateEvent("processinstances", ProcessInstance.class.getName()));
        this.indexCreateOrUpdateEvent.fire((Object)new IndexCreateOrUpdateEvent("usertaskinstances", UserTaskInstance.class.getName()));
        this.indexCreateOrUpdateEvent.fire((Object)new IndexCreateOrUpdateEvent("jobs", Job.class.getName()));
    }

    public <V, E> MongoEntityMapper<V, E> getEntityMapper(String name) {
        Supplier<MongoEntityMapper<?, ?>> supplier = ENTITY_MAPPER_MAP.get(name);
        if (Objects.nonNull(supplier)) {
            return supplier.get();
        }
        if (Constants.isDomainCollection(name)) {
            return new DomainEntityMapper();
        }
        return null;
    }
}

