/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import java.util.Collections;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.mongodb.model.ProcessDefinitionEntity;
import org.kie.kogito.index.mongodb.model.ProcessDefinitionEntityMapper;

class ProcessDefinitionEntityMapperTest {
    ProcessDefinitionEntityMapper mapper = new ProcessDefinitionEntityMapper();
    ProcessDefinition pd = new ProcessDefinition();
    ProcessDefinitionEntity entity = new ProcessDefinitionEntity();

    ProcessDefinitionEntityMapperTest() {
    }

    @BeforeEach
    void setup() {
        String version = "1.0";
        String processId = "testProcessId";
        Set<String> roles = Collections.singleton("testRoles");
        String type = "testType";
        Set<String> addons = Collections.singleton("testAddons");
        this.pd.setId(processId);
        this.pd.setVersion(version);
        this.pd.setRoles(roles);
        this.pd.setAddons(addons);
        this.pd.setType(type);
        this.entity.setId(processId);
        this.entity.setVersion(version);
        this.entity.setRoles(roles);
        this.entity.setAddons(addons);
        this.entity.setType(type);
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(ProcessDefinitionEntity.class, (Object)this.mapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        ProcessDefinitionEntity result = this.mapper.mapToEntity(this.pd.getId(), this.pd);
        Assertions.assertEquals((Object)this.entity, (Object)result);
    }

    @Test
    void testMapToModel() {
        ProcessDefinition result = this.mapper.mapToModel(this.entity);
        Assertions.assertEquals((Object)this.pd, (Object)result);
    }

    @Test
    void testConvertToMongoAttribute() {
        Assertions.assertEquals((Object)"_id", (Object)this.mapper.convertToMongoAttribute("_id"));
        String testAttribute = "testAttribute";
        Assertions.assertEquals((Object)testAttribute, (Object)this.mapper.convertToMongoAttribute(testAttribute));
    }

    @Test
    void testConvertToModelAttribute() {
        Assertions.assertEquals((Object)"id", (Object)this.mapper.convertToModelAttribute("id"));
        String testAttribute = "test.attribute.go";
        Assertions.assertEquals((Object)testAttribute, (Object)this.mapper.convertToModelAttribute(testAttribute));
    }
}

