/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.model.ProcessIdEntity;
import org.kie.kogito.index.mongodb.model.ProcessIdEntityMapper;

class ProcessIdEntityMapperTest {
    ProcessIdEntityMapper processIdEntityMapper = new ProcessIdEntityMapper();

    ProcessIdEntityMapperTest() {
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(ProcessIdEntity.class, (Object)this.processIdEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        String testId = "testProcessId";
        String testValue = "testProcessType";
        ProcessIdEntity result = this.processIdEntityMapper.mapToEntity(testId, testValue);
        ProcessIdEntity processIdEntity = new ProcessIdEntity();
        processIdEntity.setProcessId(testId);
        processIdEntity.setFullTypeName(testValue);
        Assertions.assertEquals((Object)processIdEntity, (Object)result);
    }

    @Test
    void testMapToModel() {
        String testId = "testProcessId";
        String testValue = "testProcessType";
        ProcessIdEntity processIdEntity = new ProcessIdEntity();
        processIdEntity.setProcessId(testId);
        processIdEntity.setFullTypeName(testValue);
        String result = this.processIdEntityMapper.mapToModel(processIdEntity);
        Assertions.assertEquals((Object)testValue, (Object)result);
    }

    @Test
    void testConvertToMongoAttribute() {
        Assertions.assertEquals((Object)"_id", (Object)this.processIdEntityMapper.convertToMongoAttribute("processId"));
        String testAttribute = "testAttribute";
        Assertions.assertEquals((Object)testAttribute, (Object)this.processIdEntityMapper.convertToMongoAttribute(testAttribute));
    }

    @Test
    void testConvertToModelAttribute() {
        Assertions.assertEquals((Object)"processId", (Object)this.processIdEntityMapper.convertToModelAttribute("_id"));
        String testAttribute = "test.attribute.name";
        Assertions.assertEquals((Object)"name", (Object)this.processIdEntityMapper.convertToModelAttribute(testAttribute));
    }
}

